/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.log;

import com.weicoder.common.lang.Conversion;
import com.weicoder.common.log.Log;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4j2
implements Log {
    private Logger log;

    public void setClass(Class<?> c) {
        this.log = c == null ? LogManager.getLogger() : LogManager.getLogger(c);
    }

    public void trace(String msg, Object ... params) {
        this.log.trace(msg, Log4j2.params(params));
    }

    public void trace(Throwable t) {
        this.log.trace("", t);
    }

    public void debug(String msg, Object ... params) {
        this.log.debug(msg, Log4j2.params(params));
    }

    public void debug(Throwable t) {
        this.log.debug("", t);
    }

    public void info(String msg, Object ... params) {
        this.log.info(msg, Log4j2.params(params));
    }

    public void info(Throwable t) {
        this.log.info("", t);
    }

    public void warn(String msg, Object ... params) {
        this.log.warn(msg, Log4j2.params(params));
    }

    public void warn(Throwable t) {
        this.log.warn("", t);
    }

    public void error(String msg, Object ... params) {
        this.log.error(msg, Log4j2.params(params));
    }

    public void error(Throwable t) {
        this.error("", t);
    }

    public void error(String msg, Throwable t) {
        this.log.error(msg, t);
    }

    public void error(Throwable t, String msg, Object ... params) {
        this.error(String.format(StringUtil.replaceAll((String)msg, (String)"\\{}", (String)"%s"), Log4j2.params(params)), t);
    }

    public boolean isTrace() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebug() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfo() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarn() {
        return this.log.isWarnEnabled();
    }

    public boolean isError() {
        return this.log.isErrorEnabled();
    }

    private static Object[] params(Object ... params) {
        if (CommonParams.LOGS_LEN > 0) {
            for (int i = 0; i < params.length; ++i) {
                Object obj = params[i];
                if (obj instanceof byte[]) {
                    obj = Arrays.toString((byte[])obj);
                } else if (obj instanceof String[]) {
                    obj = Arrays.toString((String[])obj);
                }
                params[i] = StringUtil.subString((String)Conversion.toString((Object)obj), (int)0, (int)CommonParams.LOGS_LEN);
            }
        }
        return params;
    }
}

