/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Conversion;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.EmptyUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;

public final class ProtobufEngine {
    public static byte[] toBytes(Object obj) {
        try {
            Class<?> c = obj.getClass();
            List fields = BeanUtil.getFields(c);
            byte[] result = new byte[ProtobufEngine.getSerializedSize(obj, c, fields)];
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])result);
            ProtobufEngine.writeTo(output, obj, fields);
            output.checkNoSpaceLeft();
            return result;
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
            return ArrayConstants.BYTES_EMPTY;
        }
    }

    public static <E> E toBean(byte[] b, Class<E> c) {
        Object bean = BeanUtil.newInstance(c);
        try {
            CodedInputStream input = CodedInputStream.newInstance((byte[])b, (int)0, (int)b.length);
            List fields = BeanUtil.getFields(c);
            int tag = input.readTag();
            int num = WireFormat.getTagFieldNumber((int)tag);
            for (int i = 1; i < fields.size() && tag != 0; ++i) {
                if (num > i) continue;
                Field field = (Field)fields.get(i - 1);
                Class<?> type = field.getType();
                if (type.equals(String.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readStringRequireUtf8());
                } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readInt32());
                } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readInt64());
                } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readBool());
                } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)Float.valueOf(input.readFloat()));
                } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readDouble());
                } else if (type.equals(ByteString.class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readBytes());
                } else if (type.equals(byte[].class)) {
                    BeanUtil.setFieldValue((Object)bean, (Field)field, (Object)input.readByteArray());
                }
                tag = input.readTag();
                num = WireFormat.getTagFieldNumber((int)tag);
            }
            input.checkLastTagWas(0);
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
        return (E)bean;
    }

    private static int getSerializedSize(Object obj, Class<?> c, List<Field> fields) {
        int size = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Object n;
            Field field = fields.get(i);
            Object val = BeanUtil.getFieldValue((Object)obj, (Field)field);
            if (val == null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                String s = Conversion.toString((Object)val);
                if (!EmptyUtil.isNotEmpty((Object)s)) continue;
                size += CodedOutputStream.computeStringSize((int)i, (String)s);
                continue;
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                int n2 = Conversion.toInt((Object)val);
                if (n2 == 0) continue;
                size += CodedOutputStream.computeInt32Size((int)i, (int)n2);
                continue;
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                long n3 = Conversion.toLong((Object)val);
                if (n3 == 0L) continue;
                size += CodedOutputStream.computeInt64Size((int)i, (long)n3);
                continue;
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                boolean n4 = Conversion.toBoolean((Object)val);
                if (!n4) continue;
                size += CodedOutputStream.computeBoolSize((int)i, (boolean)n4);
                continue;
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                float n5 = Conversion.toFloat((Object)val);
                if (n5 == 0.0f) continue;
                size += CodedOutputStream.computeFloatSize((int)i, (float)n5);
                continue;
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                double n6 = Conversion.toDouble((Object)val);
                if (n6 == 0.0) continue;
                size += CodedOutputStream.computeDoubleSize((int)i, (double)n6);
                continue;
            }
            if (type.equals(ByteString.class)) {
                n = (ByteString)val;
                if (n.isEmpty()) continue;
                size += CodedOutputStream.computeBytesSize((int)i, (ByteString)n);
                continue;
            }
            if (!type.equals(byte[].class) || !EmptyUtil.isNotEmpty((Object)(n = (Object)((byte[])val)))) continue;
            size += CodedOutputStream.computeByteArraySize((int)i, (byte[])n);
        }
        return size;
    }

    private static void writeTo(CodedOutputStream output, Object obj, List<Field> fields) throws IOException {
        for (int i = 1; i <= fields.size(); ++i) {
            Object n;
            Field field = fields.get(i - 1);
            Object val = BeanUtil.getFieldValue((Object)obj, (Field)field);
            if (val == null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                String s = Conversion.toString((Object)val);
                if (!EmptyUtil.isNotEmpty((Object)s)) continue;
                output.writeString(i, s);
                continue;
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                int n2 = Conversion.toInt((Object)val);
                if (n2 == 0) continue;
                output.writeInt32(i, n2);
                continue;
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                long n3 = Conversion.toLong((Object)val);
                if (n3 == 0L) continue;
                output.writeInt64(i, n3);
                continue;
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                boolean n4 = Conversion.toBoolean((Object)val);
                if (!n4) continue;
                output.writeBool(i, n4);
                continue;
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                float n5 = Conversion.toFloat((Object)val);
                if (n5 == 0.0f) continue;
                output.writeFloat(i, n5);
                continue;
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                double n6 = Conversion.toDouble((Object)val);
                if (n6 == 0.0) continue;
                output.writeDouble(i, n6);
                continue;
            }
            if (type.equals(ByteString.class)) {
                n = (ByteString)val;
                if (n.isEmpty()) continue;
                output.writeBytes(i, n);
                continue;
            }
            if (!type.equals(byte[].class) || !EmptyUtil.isNotEmpty((Object)(n = (Object)((byte[])val)))) continue;
            output.writeByteArray(i, (byte[])n);
        }
    }

    private ProtobufEngine() {
    }
}

