/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.core.quartz;

import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.ClassUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.core.params.QuartzParams;
import com.weicoder.core.quartz.Job;
import com.weicoder.core.quartz.Jobs;
import com.weicoder.core.quartz.Trigger;
import java.lang.reflect.Method;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public final class Quartzs {
    public static final void init() {
        try {
            List jobs = ClassUtil.getAnnotationClass((String)CommonParams.getPackages((String)"quartz"), Job.class);
            if (EmptyUtil.isNotEmpty((Object)jobs)) {
                Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
                jobs.forEach(c -> {
                    try {
                        Object obj = BeanUtil.newInstance((Class)c);
                        TriggerBuilder builder = TriggerBuilder.newTrigger();
                        for (Method m : c.getDeclaredMethods()) {
                            Trigger t = m.getAnnotation(Trigger.class);
                            if (t == null) continue;
                            JobDetail job = JobBuilder.newJob(Jobs.class).build();
                            JobDataMap map = job.getJobDataMap();
                            map.put("method", (Object)m);
                            map.put("obj", obj);
                            scheduler.scheduleJob(job, builder.withIdentity(m.getName(), obj.getClass().getSimpleName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)QuartzParams.getTrigger(m.getName(), t.value()))).build());
                            Logs.info((String)"add quartz job={}", (Object[])new Object[]{job});
                        }
                    }
                    catch (Exception e) {
                        Logs.error((Throwable)e);
                    }
                });
                scheduler.start();
            }
        }
        catch (Exception e) {
            Logs.error((Throwable)e);
        }
    }

    private Quartzs() {
    }
}

