/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.easymock.MockControl;
import org.easymock.internal.IBehaviorFactory;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.RecordState;

public class MockClassControl
extends MockControl {
    private static InvocationHandler donothing = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    };

    private static Object handlePrimitiveType(Class type) {
        return RecordState.emptyReturnValueFor((Class)type);
    }

    private static Constructor getConstructorToUse(Class clazz) {
        try {
            return clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getConstructors().length == 0) {
                throw new IllegalArgumentException("No visible constructors in class " + clazz.getName());
            }
            return clazz.getConstructors()[0];
        }
    }

    private static Object[] getArgsForTypes(Class[] methodTypes) {
        Object[] methodArgs = new Object[methodTypes.length];
        int i = 0;
        while (i < methodTypes.length) {
            if (methodTypes[i].isInterface()) {
                methodArgs[i] = Proxy.newProxyInstance(methodTypes[i].getClassLoader(), new Class[]{methodTypes[i]}, donothing);
            } else if (methodTypes[i].isPrimitive()) {
                methodArgs[i] = MockClassControl.handlePrimitiveType(methodTypes[i]);
            } else if (Modifier.isFinal(methodTypes[i].getModifiers())) {
                Constructor argConstructor = MockClassControl.getConstructorToUse(methodTypes[i]);
                try {
                    methodArgs[i] = argConstructor.newInstance(MockClassControl.getArgsForTypes(argConstructor.getParameterTypes()));
                }
                catch (Exception ex) {
                    throw new Error(ex);
                }
            } else {
                MockControl ctrl = MockClassControl.createControl(methodTypes[i]);
                methodArgs[i] = ctrl.getMock();
            }
            ++i;
        }
        return methodArgs;
    }

    public static MockClassControl createControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs) {
        return new MockClassControl(classToMock, constructorTypes, constructorArgs, MockControl.UNORDERED_BEHAVIOR_FACTORY);
    }

    public static MockClassControl createControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs, Method[] mockedMethods) {
        return new MockClassControl(classToMock, constructorTypes, constructorArgs, mockedMethods, MockControl.UNORDERED_BEHAVIOR_FACTORY);
    }

    public static MockControl createControl(Class classToMock) {
        if (classToMock.isInterface()) {
            return MockControl.createControl((Class)classToMock);
        }
        return new MockClassControl(classToMock, null, null, MockControl.UNORDERED_BEHAVIOR_FACTORY);
    }

    public static MockClassControl createStrictControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs) {
        return new MockClassControl(classToMock, constructorTypes, constructorArgs, MockControl.ORDERED_BEHAVIOR_FACTORY);
    }

    public static MockClassControl createStrictControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs, Method[] mockedMethods) {
        return new MockClassControl(classToMock, constructorTypes, constructorArgs, mockedMethods, MockControl.ORDERED_BEHAVIOR_FACTORY);
    }

    public static MockControl createStrictControl(Class classToMock) {
        if (classToMock.isInterface()) {
            return MockControl.createStrictControl((Class)classToMock);
        }
        return new MockClassControl(classToMock, null, null, MockControl.ORDERED_BEHAVIOR_FACTORY);
    }

    public static MockClassControl createNiceControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs) {
        return new MockClassControl(classToMock, constructorTypes, constructorArgs, MockControl.NICE_BEHAVIOR_FACTORY);
    }

    public static MockClassControl createNiceControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs, Method[] mockedMethods) {
        return new MockClassControl(classToMock, constructorTypes, constructorArgs, mockedMethods, MockControl.NICE_BEHAVIOR_FACTORY);
    }

    public static MockControl createNiceControl(Class classToMock) {
        if (classToMock.isInterface()) {
            return MockControl.createNiceControl((Class)classToMock);
        }
        return new MockClassControl(classToMock, null, null, MockControl.NICE_BEHAVIOR_FACTORY);
    }

    private MockClassControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs, Method[] mockedMethods, IBehaviorFactory behaviorFactory) {
        super(classToMock, (IProxyFactory)new ClassProxyFactory(constructorTypes, constructorArgs, mockedMethods), behaviorFactory);
    }

    private MockClassControl(Class classToMock, Class[] constructorTypes, Object[] constructorArgs, IBehaviorFactory behaviorFactory) {
        this(classToMock, constructorTypes, constructorArgs, null, behaviorFactory);
    }

    static class ClassProxyFactory
    implements IProxyFactory {
        private Object[] constructorArgs;
        private Class[] constructorTypes;
        private Set mockedMethods;

        public ClassProxyFactory(Class[] constructorTypes, Object[] constructorArgs, Method[] mockedMethods) {
            this.constructorTypes = constructorTypes;
            this.constructorArgs = constructorArgs;
            this.mockedMethods = mockedMethods == null ? null : new HashSet<Method>(Arrays.asList(mockedMethods));
        }

        public Object createProxy(Class toMock, InvocationHandler handler) {
            MethodInterceptor interceptor = new MethodInterceptor(this, handler){
                private final /* synthetic */ InvocationHandler val$handler;
                private final /* synthetic */ ClassProxyFactory this$0;
                {
                    this.this$0 = this$0;
                    this.val$handler = val$handler;
                }

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (ClassProxyFactory.access$000(this.this$0) != null && !ClassProxyFactory.access$000(this.this$0).contains(method)) {
                        return proxy.invokeSuper(obj, args);
                    }
                    return this.val$handler.invoke(proxy, method, args);
                }
            };
            try {
                if (this.constructorTypes == null) {
                    Constructor constructor = MockClassControl.getConstructorToUse(toMock);
                    this.constructorTypes = constructor.getParameterTypes();
                    this.constructorArgs = MockClassControl.getArgsForTypes(this.constructorTypes);
                }
                Enhancer enhancer = new Enhancer();
                enhancer.setSuperclass(toMock);
                enhancer.setCallback((Callback)interceptor);
                return enhancer.create(this.constructorTypes, this.constructorArgs);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        static /* synthetic */ Set access$000(ClassProxyFactory x0) {
            return x0.mockedMethods;
        }
    }
}

