/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.pdf;

import fr.opensagres.xdocreport.itext.extension.font.AbstractFontRegistry;

public class ITextFontRegistry
extends AbstractFontRegistry {
    private static final String TIMES_NEW_ROMAN_FONT_FAMILY_NAME = "Times New Roman";
    private static final String COURRIER_NEW_FONT_FAMILY_NAME = "Courier New";
    private static final ITextFontRegistry INSTANCE = new ITextFontRegistry();

    public static ITextFontRegistry getRegistry() {
        return INSTANCE;
    }

    protected String resolveFamilyName(String familyName, int style) {
        boolean bold = this.isBold(style);
        boolean italic = this.isItalic(style);
        if (COURRIER_NEW_FONT_FAMILY_NAME.equals(familyName)) {
            if (bold && italic) {
                return "Courier-BoldOblique";
            }
            if (bold) {
                return "Courier-Bold";
            }
            if (italic) {
                return "Courier-Oblique";
            }
            return "Courier";
        }
        if (TIMES_NEW_ROMAN_FONT_FAMILY_NAME.equals(familyName)) {
            if (bold && italic) {
                return "Times-BoldItalic";
            }
            if (bold) {
                return "Times-Bold";
            }
            if (italic) {
                return "Times-Italic";
            }
            return "Times-Roman";
        }
        return familyName;
    }
}

