/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.pdf.internal.elements;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;
import java.math.BigInteger;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.apache.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import org.apache.poi.xwpf.converter.pdf.internal.elements.StylableTable;
import org.apache.poi.xwpf.converter.pdf.internal.elements.StylableTableCell;

public class StylableHeaderFooter
extends StylableTable
implements IMasterPageHeaderFooter {
    private final StylableDocument ownerDocument;
    private final boolean header;
    private StylableTableCell tableCell;
    private boolean flushed;
    private final Float y;

    public StylableHeaderFooter(StylableDocument ownerDocument, BigInteger dxaY, boolean header) {
        super(ownerDocument, null, 1);
        this.ownerDocument = ownerDocument;
        this.header = header;
        this.tableCell = ownerDocument.createTableCell(this);
        this.tableCell.setBorder(0);
        this.tableCell.setPadding(0.0f);
        this.y = dxaY != null ? Float.valueOf(DxaUtil.dxa2points((BigInteger)dxaY)) : null;
    }

    public StylableTableCell getTableCell() {
        return this.tableCell;
    }

    private void setWidthIfNecessary() {
        float headerFooterWidth = this.ownerDocument.right() - this.ownerDocument.left();
        if (this.getTotalWidth() != headerFooterWidth) {
            this.setTotalWidth(headerFooterWidth);
        }
    }

    public float getTotalHeight() {
        this.setWidthIfNecessary();
        return super.getRowHeight(0);
    }

    public void flush() {
        if (this.flushed) {
            return;
        }
        super.addCell((PdfPCell)this.tableCell);
        this.flushed = true;
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas) {
        this.setWidthIfNecessary();
        return super.writeSelectedRows(rowStart, rowEnd, xPos, yPos, canvas);
    }

    public Float getY() {
        return this.y;
    }
}

