/*
 * Decompiled with CFR 0.152.
 */
package hera.server;

import hera.server.Server;
import hera.server.ServerEvent;
import hera.server.ServerListener;
import hera.server.ServerStatus;
import hera.server.StateChangeListener;
import hera.server.StateMachine;
import hera.util.ValidationUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements Server,
StateChangeListener<ServerStatus> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected StateMachine<ServerStatus> state = new StateMachine<ServerStatus>(ServerStatus.TERMINATED);
    protected ArrayList<ServerListener> listeners = new ArrayList();
    protected Throwable exception = null;
    protected String name = this.getClass().getSimpleName();

    public AbstractServer() {
        this.state.addListener(this);
    }

    @Override
    public ServerStatus getStatus() {
        return this.state.getState();
    }

    @Override
    public boolean isStatus(ServerStatus ... status) {
        return this.state.isState((ServerStatus[])status);
    }

    @Override
    public void waitStatus(ServerStatus ... status) {
        this.state.waitState((ServerStatus[])status);
    }

    protected void changeStatus(ServerStatus status) {
        this.state.changeState(status, new Object[0]);
    }

    @Override
    public void stateChanged(ServerStatus old, ServerStatus state, Object ... args) {
        this.fireEvent(new ServerEvent(this, 1, (Object)old, (Object)state));
    }

    public void clearException() {
        this.exception = null;
    }

    @Override
    public void addServerListener(ServerListener listener) {
        ValidationUtils.assertNotNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeServerListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.handle(event);
        }
        if (this.listeners.isEmpty()) {
            this.logger.trace("Event[{}] is discarded", (Object)event);
        } else {
            this.logger.info("Event[{}] is fired to {} listeners", (Object)event, (Object)this.listeners.size());
        }
    }

    protected void initialize() throws Exception {
    }

    protected void process() throws Exception {
    }

    protected void handleError(Throwable th) {
        throw new IllegalStateException(th);
    }

    protected void terminate() {
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getName() {
        return this.name;
    }
}

