/*
 * Decompiled with CFR 0.152.
 */
package hera.server;

import hera.server.StateChangeListener;
import hera.server.StateCondition;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine<StateT> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected Collection<StateChangeListener<StateT>> listeners = new LinkedHashSet<StateChangeListener<StateT>>();
    protected StateT state;
    protected Object[] args;

    public StateMachine(StateT initialState) {
        this.state = initialState;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void addListener(StateChangeListener<StateT> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(StateChangeListener<StateT> listener) {
        this.listeners.remove(listener);
    }

    public boolean isState(StateT ... states) {
        Object temp = null;
        this.lock.readLock().lock();
        try {
            temp = this.state;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (StateT st : states) {
            if (temp != st) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitState(StateT ... states) {
        while (true) {
            boolean isLocked = false;
            this.lock.readLock().lock();
            try {
                isLocked = true;
                if (this.isState(states)) {
                    return;
                }
                StateMachine stateMachine = this;
                synchronized (stateMachine) {
                    this.lock.readLock().unlock();
                    isLocked = false;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.warn("Interrupt waiting");
                    }
                    continue;
                }
            }
            finally {
                if (!isLocked) continue;
                this.lock.readLock().unlock();
                continue;
            }
            break;
        }
    }

    public StateT getState() {
        this.lock.readLock().lock();
        try {
            StateT StateT = this.state;
            return StateT;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object[] getArguments() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.args;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeState(StateT state, Object ... args) {
        this.lock.writeLock().lock();
        try {
            StateT old = this.state;
            this.state = state;
            this.args = args;
            this.logger.info("Status: {} -> {}", old, this.state);
            StateMachine stateMachine = this;
            synchronized (stateMachine) {
                this.notifyAll();
            }
            this.fireChangeEvent(old, this.state, args);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeState(StateT state, StateCondition<StateT> condition, Object ... args) {
        this.lock.writeLock().lock();
        try {
            if (!condition.evaluate(this)) {
                boolean bl = false;
                return bl;
            }
            this.changeState(state, new Object[0]);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Callable<Void> process, StateT success, StateT fail) {
        this.lock.writeLock().lock();
        try {
            process.call();
            this.logger.trace("Success to execute {}", process);
            if (null != success) {
                this.changeState(success, new Object[0]);
            }
        }
        catch (Throwable th) {
            if (null != fail) {
                this.logger.trace("Fail to execute {}", process);
                this.changeState(fail, new Object[0]);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void fireChangeEvent(StateT from, StateT to, Object ... args) {
        for (StateChangeListener<StateT> listener : this.listeners) {
            try {
                listener.stateChanged(from, to, args);
            }
            catch (Throwable e) {
                this.logger.debug("Unexpected exception in listener", e);
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getState() + "]";
    }
}

