/*
 * Decompiled with CFR 0.152.
 */
package hera.server;

import hera.server.AbstractServer;
import hera.server.ServerStatus;
import hera.server.StateConditionFactory;
import hera.util.StringUtils;

public class ThreadServer
extends AbstractServer
implements Runnable {
    protected Thread thread = null;
    protected final ServerStatus[] loopCondition = new ServerStatus[]{ServerStatus.PROCESSING, ServerStatus.SKIP};
    protected final ServerStatus[] processingCondition = new ServerStatus[]{ServerStatus.PROCESSING};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.logger.trace("Starting {} server...", (Object)this.getName());
        this.state.getLock().writeLock().lock();
        try {
            if (this.isStatus(ServerStatus.DOWNING)) {
                this.logger.info("Starting is cancelled.");
                this.changeStatus(ServerStatus.TERMINATED);
                return;
            }
            this.logger.debug("Doing pre-process...");
            this.changeStatus(ServerStatus.INITIALIZING);
        }
        catch (Throwable e) {
            this.logger.error("Server got unexpected exception:", e);
        }
        finally {
            this.state.getLock().writeLock().unlock();
        }
        this.clearException();
        try {
            this.initialize();
            this.logger.info("Pre-process done.");
        }
        catch (Throwable e) {
            this.exception = e;
            this.logger.error("Exception occurred in pre-process.", e);
            this.changeStatus(ServerStatus.TERMINATED);
            return;
        }
        this.state.getLock().writeLock().lock();
        try {
            if (this.isStatus(ServerStatus.DOWNING)) {
                this.changeStatus(ServerStatus.TERMINATING);
            } else {
                this.changeStatus(ServerStatus.PROCESSING);
                this.logger.info("{} started.", (Object)this);
            }
        }
        finally {
            this.state.getLock().writeLock().unlock();
        }
        try {
            this.logger.debug("{}'s main process started.", (Object)this);
            this.loop();
            this.logger.debug("{}'s main process done.", (Object)this);
            return;
        }
        finally {
            this.logger.debug("Doing post-process...");
            try {
                this.terminate();
                this.logger.info("Post-process done.");
            }
            catch (Throwable th) {
                this.logger.error("Exception occurred in post-process.", th);
            }
            finally {
                this.changeStatus(ServerStatus.TERMINATED);
            }
        }
    }

    protected void loop() {
        while (this.isStatus(this.loopCondition)) {
            if (!this.isStatus(this.processingCondition)) continue;
            try {
                this.logger.trace("{}'s task started.", (Object)this);
                this.process();
                this.logger.trace("{}'s task done.", (Object)this);
            }
            catch (Throwable e) {
                this.exception = e;
                this.logger.error("Error :{}", (Object)StringUtils.nvl(e.getLocalizedMessage(), e.getMessage()), (Object)e);
                this.handleError(e);
            }
        }
    }

    @Override
    protected void process() throws Exception {
    }

    @Override
    public void boot() {
        this.boot(false);
    }

    public void boot(boolean isBlock) {
        if (!this.state.changeState(ServerStatus.BOOTING, StateConditionFactory.when(ServerStatus.TERMINATED), new Object[0])) {
            this.logger.error("{} is not terminated status. status: {}", (Object)this, (Object)this.state);
            throw new IllegalStateException();
        }
        this.thread = new Thread((Runnable)this, this.getName());
        this.logger.debug("Starting {}...", (Object)this);
        this.thread.start();
        this.logger.trace("Staring post-process for boot.");
        this.postBoot();
        if (isBlock) {
            this.waitStatus(ServerStatus.PROCESSING, ServerStatus.TERMINATED);
        }
    }

    protected void postBoot() {
    }

    @Override
    public void down() {
        this.down(false);
    }

    public void down(boolean isBlock) {
        if (!this.state.changeState(ServerStatus.DOWNING, StateConditionFactory.when(StateConditionFactory.not(ServerStatus.DOWNING, ServerStatus.TERMINATING, ServerStatus.TERMINATED)), new Object[0])) {
            this.logger.error("{} is already stopped.", (Object)this);
            return;
        }
        this.logger.trace("Staring pre-process for down...");
        this.preDown();
        this.thread = null;
        if (isBlock) {
            this.logger.debug("Wait for {} to be stopped.", (Object)this);
            this.waitStatus(ServerStatus.TERMINATED);
        }
        this.logger.info("{} stopped.", (Object)this);
    }

    protected void preDown() {
    }

    public String toString() {
        return "Server[" + this.getName() + "]";
    }
}

