/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.StringUtils;
import hera.util.ValidationUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;

public class NumberUtils {
    public static <T> T convert(Number number, Class<T> targetClass) throws IllegalArgumentException {
        ValidationUtils.assertNotNull((Object)number, "Number must not be null");
        ValidationUtils.assertNotNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number)) {
            return (T)number;
        }
        if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
            long value = number.longValue();
            if (value < -128L || 127L < value) {
                NumberUtils.throwOverflowException(number, targetClass);
            }
            return (T)Byte.valueOf((byte)value);
        }
        if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
            long value = number.longValue();
            if (value < -32768L || 32767L < value) {
                NumberUtils.throwOverflowException(number, targetClass);
            }
            return (T)Short.valueOf((short)value);
        }
        if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || Integer.MAX_VALUE < value) {
                NumberUtils.throwOverflowException(number, targetClass);
            }
            return (T)Integer.valueOf((int)value);
        }
        if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
            return (T)Long.valueOf(number.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void throwOverflowException(Number number, Class<?> targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static <T> T parse(String text, Class<?> clazz) {
        ValidationUtils.assertNotNull((Object)text, "Text must not be null");
        ValidationUtils.assertNotNull(clazz, "Target class must not be null");
        String trimmed = StringUtils.trim(text);
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return (T)Byte.decode(trimmed);
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return (T)Short.decode(trimmed);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (T)Integer.decode(trimmed);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (T)Long.decode(trimmed);
        }
        if (clazz.equals(BigInteger.class)) {
            return (T)NumberUtils.decodeBigInteger(trimmed);
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return (T)Float.valueOf(trimmed);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (T)Double.valueOf(trimmed);
        }
        if (clazz.equals(BigDecimal.class) || clazz.equals(Number.class)) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + clazz.getName() + "]");
    }

    public static <T> T parse(String text, Class<T> targetClass, NumberFormat numberFormat) {
        boolean noFormat;
        boolean bl = noFormat = null == numberFormat;
        if (noFormat) {
            return NumberUtils.parse(text, targetClass);
        }
        ValidationUtils.assertNotNull((Object)text, "Text must not be null");
        ValidationUtils.assertNotNull(targetClass, "Target class must not be null");
        DecimalFormat decimalFormat = null;
        boolean resetBigDecimal = false;
        if (numberFormat instanceof DecimalFormat) {
            decimalFormat = (DecimalFormat)numberFormat;
            if (BigDecimal.class.equals(targetClass) && !decimalFormat.isParseBigDecimal()) {
                decimalFormat.setParseBigDecimal(true);
                resetBigDecimal = true;
            }
        }
        try {
            Number number = numberFormat.parse(StringUtils.trim(text));
            T t = NumberUtils.convert(number, targetClass);
            return t;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse number: " + ex.getMessage(), ex);
        }
        finally {
            if (resetBigDecimal) {
                decimalFormat.setParseBigDecimal(false);
            }
        }
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && 1 + index < value.length()) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static byte[] positiveToByteArray(BigInteger positiveNumber) {
        int positiveByteCapacity;
        if (null == positiveNumber) {
            return new byte[0];
        }
        ValidationUtils.assertTrue(positiveNumber.compareTo(BigInteger.ZERO) >= 0, "Argument must greater than or equals to 0");
        byte[] raw = positiveNumber.toByteArray();
        int n = positiveByteCapacity = positiveNumber.equals(BigInteger.ZERO) ? 1 : positiveNumber.bitLength() + 7 >>> 3;
        if (raw.length > positiveByteCapacity) {
            return Arrays.copyOfRange(raw, 1, raw.length);
        }
        return raw;
    }

    public static BigInteger byteArrayToPositive(byte[] rawBytes) {
        if (null == rawBytes || rawBytes.length == 0) {
            return BigInteger.ZERO;
        }
        byte[] canonicalBytes = rawBytes;
        if ((rawBytes[0] & 0x80) != 0) {
            canonicalBytes = new byte[rawBytes.length + 1];
            canonicalBytes[0] = 0;
            System.arraycopy(rawBytes, 0, canonicalBytes, 1, rawBytes.length);
        }
        return new BigInteger(canonicalBytes);
    }
}

