/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha256Utils {
    public static byte[] getBytes(CharSequence str) {
        try {
            return str.toString().getBytes("utf8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static byte[] digest(byte[] raw) {
        try {
            MessageDigest digest = Sha256Utils.createDigest();
            return digest.digest(raw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] digest(byte[] ... raws) {
        try {
            MessageDigest digest = Sha256Utils.createDigest();
            for (byte[] raw : raws) {
                digest.update(raw);
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static MessageDigest createDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-256");
    }

    public static String mask(CharSequence raw) {
        if (null == raw) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(raw.length());
        for (int i = 0; i < raw.length(); ++i) {
            buffer.append("*");
        }
        return buffer.toString();
    }
}

