/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringUtils {
    public static final String NULL_STRING = "<<null>>";
    public static final String EMPTY_STRING = "";

    public static boolean isEmpty(CharSequence str) {
        if (null == str) {
            return true;
        }
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence str) {
        if (null == str) {
            return 0;
        }
        return str.length();
    }

    public static boolean hasLength(CharSequence str) {
        return 0 < StringUtils.length(str);
    }

    public static boolean hasText(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static String nvl(String ... strs) {
        String val = ObjectUtils.nvl(strs);
        if (null == val) {
            return EMPTY_STRING;
        }
        return val;
    }

    public static List<String> split(String string, String delimiter) {
        if (null == string || null == delimiter) {
            return null;
        }
        ArrayList<String> words = new ArrayList<String>();
        int from = 0;
        int to = 0;
        int wordLength = delimiter.length();
        while (0 <= (to = string.indexOf(delimiter, from))) {
            words.add(string.substring(from, to));
            from = to + wordLength;
        }
        if (from < string.length()) {
            words.add(string.substring(from));
        }
        return words;
    }

    public static String split(String string, String delimiter, int index) {
        List<String> words = StringUtils.split(string, delimiter);
        if (words != null && 0 <= index && index < words.size()) {
            return words.get(index);
        }
        return null;
    }

    public static String ltrim(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(chs[i])) continue;
            return new String(chs, i, str.length() - i);
        }
        return EMPTY_STRING;
    }

    public static String rtrim(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = chs.length - 1;
        for (int j = chs.length; 0 < j; --j) {
            if (!Character.isWhitespace(chs[i])) {
                return new String(chs, 0, j);
            }
            --i;
        }
        return EMPTY_STRING;
    }

    public static String trim(String str) {
        return StringUtils.rtrim(StringUtils.ltrim(str));
    }

    public static String join(Iterable<?> values, String token) {
        boolean init = false;
        StringBuilder buffer = new StringBuilder();
        for (Object value : values) {
            if (init) {
                buffer.append(token);
            }
            init = true;
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static String join(Object[] values, String token) {
        return StringUtils.join(Arrays.asList(values), token);
    }

    public static String multiply(String word, int repeat) {
        if (null == word) {
            return EMPTY_STRING;
        }
        StringBuilder buffer = new StringBuilder();
        StringUtils.multiply(buffer, word, repeat);
        return buffer.toString();
    }

    public static void multiply(StringBuilder buffer, String word, int repeat) {
        if (null == word) {
            return;
        }
        for (int i = 0; i < repeat; ++i) {
            buffer.append(word);
        }
    }

    public static String repeat(String word, int repeat) {
        return StringUtils.multiply(word, repeat);
    }

    public static String uncapitalize(String str) {
        if (null == str) {
            return null;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static int countMatches(String str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String removePrefix(String str, String prefix) {
        if (null == str) {
            return null;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (null == str) {
            return null;
        }
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }
}

