/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.ObjectUtils;

public class ValidationUtils {
    public static void assertTrue(boolean value, RuntimeException th) {
        if (!value) {
            throw th;
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertTrue(boolean value) {
        ValidationUtils.assertTrue(value, "Expression must be true.");
    }

    public static void assertFalse(boolean value, RuntimeException th) {
        if (value) {
            throw th;
        }
    }

    public static void assertFalse(boolean value, String message) {
        if (value) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertFalse(boolean value) {
        ValidationUtils.assertFalse(value, "Expression must be false");
    }

    public static void assertNull(Object obj, RuntimeException error) {
        ValidationUtils.assertTrue(null == obj, error);
    }

    public static void assertNull(Object obj, String message) {
        ValidationUtils.assertTrue(null == obj, message);
    }

    public static void assertNull(Object obj) {
        ValidationUtils.assertNull(obj, "The object must be null");
    }

    public static void assertNotNull(Object obj, RuntimeException error) {
        ValidationUtils.assertTrue(null != obj, error);
    }

    public static void assertNotNull(Object obj, String message) {
        ValidationUtils.assertTrue(null != obj, message);
    }

    public static void assertNotNull(Object obj) {
        ValidationUtils.assertNotNull(obj, "The object must not be null");
    }

    public static void assertEquals(Object obj1, Object obj2, RuntimeException error) {
        ValidationUtils.assertTrue(ObjectUtils.equal(obj1, obj2), error);
    }

    public static void assertEquals(Object obj1, Object obj2, String message) {
        ValidationUtils.assertTrue(ObjectUtils.equal(obj1, obj2), message);
    }

    public static void assertEquals(Object obj1, Object obj2) {
        ValidationUtils.assertEquals(obj1, obj2, obj1 + " expected but " + obj2);
    }

    public static void assertNotEquals(Object obj1, Object obj2, RuntimeException error) {
        ValidationUtils.assertFalse(ObjectUtils.equal(obj1, obj2), error);
    }

    public static void assertNotEquals(Object obj1, Object obj2, String message) {
        ValidationUtils.assertFalse(ObjectUtils.equal(obj1, obj2), message);
    }

    public static void assertNotEquals(Object obj1, Object obj2) {
        ValidationUtils.assertNotEquals(obj1, obj2, "Two objects must be not equals");
    }
}

