/*
 * Decompiled with CFR 0.152.
 */
package hera.keystore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hera.annotation.ApiAudience;
import hera.annotation.ApiStability;
import hera.api.model.Authentication;
import hera.api.model.EncryptedPrivateKey;
import hera.api.model.Identity;
import hera.api.model.KeyFormat;
import hera.exception.HerajException;
import hera.exception.InvalidAuthenticationException;
import hera.key.AergoKey;
import hera.key.KeyCipherStrategy;
import hera.key.KeyFormatV1Strategy;
import hera.key.Signer;
import hera.keystore.AbstractKeyStore;
import hera.keystore.KeyStore;
import hera.model.KeyAlias;
import hera.util.ValidationUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

@ApiAudience.Private
@ApiStability.Unstable
public class AergoKeyStore
extends AbstractKeyStore
implements KeyStore {
    protected static final String STORAGE_DIR = "keystore";
    protected static final String FIELD_VERSION = "ks_version";
    protected static final String KEYSTORE_POSTFIX = "keystore.txt";
    protected static final String KEYSTORE_SPLITER = "__";
    protected static final String KEYSTORE_TEMPLATE = "%s" + KEYSTORE_SPLITER + KEYSTORE_POSTFIX;
    protected static final Pattern STORE_REGEX = Pattern.compile("[a-zA-Z0-9]+__keystore\\.txt$");
    protected final Object lock = new Object();
    protected final ObjectMapper mapper = new ObjectMapper();
    protected final FilenameFilter filenameFilter = new AergoKeyStoreFilenameFilter();
    protected final File root;
    protected final String encryptVersion;
    protected final Map<String, KeyCipherStrategy<KeyFormat>> version2Format;

    public AergoKeyStore(String root) {
        this(root, "1");
    }

    public AergoKeyStore(String root, String encryptVersion) {
        try {
            ValidationUtils.assertNotNull((Object)root, (String)"KeyStore rootpath must not null");
            ValidationUtils.assertNotNull((Object)encryptVersion, (String)"KeyStore keyformat version must not null");
            this.logger.debug("Create an AergoKeyStore with root directory {} and encrypt version: {}", (Object)root, (Object)encryptVersion);
            File file = new File(root + "/" + STORAGE_DIR);
            if (file.exists() && file.isFile()) {
                throw new HerajException("Keystore target is a file");
            }
            if (!file.exists()) {
                boolean mkdirSuccess = file.mkdirs();
                if (!mkdirSuccess) {
                    throw new HerajException("Unable to make directory: " + root);
                }
                this.logger.debug("Create directory: {}", (Object)root);
            }
            this.root = file;
            this.encryptVersion = encryptVersion;
            HashMap<String, KeyCipherStrategy<KeyFormat>> version2Format = new HashMap<String, KeyCipherStrategy<KeyFormat>>();
            version2Format.put("1", (KeyCipherStrategy<KeyFormat>)new KeyFormatV1Strategy());
            this.version2Format = version2Format;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Authentication authentication, AergoKey key) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            ValidationUtils.assertNotNull((Object)key, (String)"Key must not null");
            this.logger.debug("Save with authentication: {}, key: {}", (Object)authentication, (Object)key);
            Object object = this.lock;
            synchronized (object) {
                String identity = authentication.getIdentity().getValue();
                if (this.hasIdentity(identity)) {
                    throw new InvalidAuthenticationException();
                }
                String path = this.root.getAbsolutePath() + "/" + this.deriveFilename(identity);
                this.logger.debug("Save key file path: {}", (Object)path);
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path));){
                    String password = authentication.getPassword();
                    KeyCipherStrategy<KeyFormat> strategy = this.version2Format.get(this.encryptVersion);
                    KeyFormat keyFormat = (KeyFormat)strategy.encrypt(key, password);
                    ((OutputStream)os).write(keyFormat.getBytesValue().getValue());
                }
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Signer load(Authentication authentication) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Load with authentication: {}", (Object)authentication);
            Object object = this.lock;
            synchronized (object) {
                return this.loadAergoKey(authentication);
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Authentication authentication) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Remove with authentication: {}", (Object)authentication);
            Object object = this.lock;
            synchronized (object) {
                File file;
                boolean deleted;
                AergoKey loaded = this.loadAergoKey(authentication);
                if (null != loaded && !(deleted = (file = this.loadKeyFile(authentication.getIdentity().getValue())).delete())) {
                    throw new HerajException("Keystore file not deleted for unknown reason");
                }
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public EncryptedPrivateKey export(Authentication authentication, String password) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            ValidationUtils.assertNotNull((Object)password, (String)"Password must not null");
            this.logger.debug("Export with authentication: {}, password: ***", (Object)authentication);
            AergoKey decrypted = this.loadAergoKey(authentication);
            return decrypted.export(password);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    protected AergoKey loadAergoKey(Authentication authentication) throws Exception {
        String identity = authentication.getIdentity().getValue();
        if (!this.hasIdentity(identity)) {
            throw new InvalidAuthenticationException();
        }
        File file = this.loadKeyFile(identity);
        KeyFormat keyFormat = KeyFormat.of((InputStream)new BufferedInputStream(new FileInputStream(file)));
        this.logger.trace("Loaded key file: {}", (Object)keyFormat);
        JsonNode jsonNode = this.mapper.reader().readTree(keyFormat.getBytesValue().getInputStream());
        JsonNode jsonVersion = jsonNode.get(FIELD_VERSION);
        if (null == jsonVersion) {
            throw new HerajException("No " + FIELD_VERSION + " field");
        }
        String version = jsonVersion.asText();
        this.logger.trace("Version: {}", (Object)version);
        KeyCipherStrategy<KeyFormat> strategy = this.version2Format.get(version);
        return strategy.decrypt((Object)keyFormat, authentication.getPassword());
    }

    @Override
    public List<Identity> listIdentities() {
        try {
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (String keyPath : this.listMatchingFiles()) {
                String identity = keyPath.split(KEYSTORE_SPLITER)[0];
                identities.add(KeyAlias.of(identity));
            }
            return identities;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public void store(String path, char[] password) {
    }

    protected boolean hasIdentity(String identity) {
        return this.listMatchingFiles().contains(this.deriveFilename(identity));
    }

    protected List<String> listMatchingFiles() {
        this.logger.trace("Matcher: {}", (Object)STORE_REGEX);
        String[] list = this.root.list(this.filenameFilter);
        if (null == list) {
            throw new HerajException("Unknown error");
        }
        List<String> matchingList = Arrays.asList(list);
        this.logger.trace("Matching files: {}", matchingList);
        return matchingList;
    }

    protected File loadKeyFile(String identity) {
        final String filename = this.deriveFilename(identity);
        File[] files = this.root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(filename);
            }
        });
        if (null == files) {
            throw new HerajException("Unknown error");
        }
        if (0 == files.length) {
            throw new HerajException("No such identity " + identity);
        }
        return files[0];
    }

    protected String deriveFilename(String identity) {
        return String.format(KEYSTORE_TEMPLATE, identity);
    }

    private class AergoKeyStoreFilenameFilter
    implements FilenameFilter {
        private AergoKeyStoreFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            AergoKeyStore.this.logger.trace("  Evaluate {}/{}", (Object)dir, (Object)name);
            return STORE_REGEX.matcher(name).matches();
        }
    }
}

