/*
 * Decompiled with CFR 0.152.
 */
package hera.keystore;

import hera.annotation.ApiAudience;
import hera.annotation.ApiStability;
import hera.api.model.Authentication;
import hera.api.model.EncryptedPrivateKey;
import hera.api.model.Identity;
import hera.exception.HerajException;
import hera.exception.InvalidAuthenticationException;
import hera.key.AergoKey;
import hera.key.Signer;
import hera.keystore.AbstractKeyStore;
import hera.keystore.KeyStore;
import hera.util.Sha256Utils;
import hera.util.ValidationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ApiAudience.Private
@ApiStability.Unstable
public class InMemoryKeyStore
extends AbstractKeyStore
implements KeyStore {
    protected final Object lock = new Object();
    protected final Set<Identity> storedIdentities = new HashSet<Identity>();
    protected final Map<String, EncryptedPrivateKey> hashedAuth2Encrypted = new HashMap<String, EncryptedPrivateKey>();

    public InMemoryKeyStore() {
        this.logger.debug("Create an InMemoryKeyStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Authentication authentication, AergoKey key) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            ValidationUtils.assertNotNull((Object)key, (String)"Save key must not null");
            this.logger.debug("Save with authentication: {}, key: {}", (Object)authentication, (Object)key.getAddress());
            String digested = this.digest(authentication);
            Object object = this.lock;
            synchronized (object) {
                if (this.storedIdentities.contains(authentication.getIdentity())) {
                    throw new InvalidAuthenticationException("Identity already exists");
                }
                if (this.hashedAuth2Encrypted.containsKey(digested)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                EncryptedPrivateKey encrypted = key.export(authentication.getPassword());
                this.logger.trace("Encrypted key: {}", (Object)encrypted);
                this.storedIdentities.add(authentication.getIdentity());
                this.hashedAuth2Encrypted.put(digested, encrypted);
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Signer load(Authentication authentication) {
        try {
            EncryptedPrivateKey encrypted;
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Load with authentication: {}", (Object)authentication);
            String digested = this.digest(authentication);
            Object object = this.lock;
            synchronized (object) {
                if (!this.hashedAuth2Encrypted.containsKey(digested)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                encrypted = this.hashedAuth2Encrypted.get(digested);
                this.logger.trace("Encrypted: {}", (Object)encrypted);
            }
            AergoKey decrypted = AergoKey.of((EncryptedPrivateKey)encrypted, (String)authentication.getPassword());
            this.logger.trace("Decrypted address: {}", (Object)decrypted.getAddress());
            return decrypted;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Authentication authentication) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Remove with authentication: {}", (Object)authentication);
            String digested = this.digest(authentication);
            Object object = this.lock;
            synchronized (object) {
                if (!this.hashedAuth2Encrypted.containsKey(digested)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                Identity identity = authentication.getIdentity();
                this.storedIdentities.remove(identity);
                this.hashedAuth2Encrypted.remove(digested);
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptedPrivateKey export(Authentication authentication, String password) {
        try {
            EncryptedPrivateKey encrypted;
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            ValidationUtils.assertNotNull((Object)password, (String)"Password must not null");
            this.logger.debug("Export with authentication: {}, password: ***", (Object)authentication);
            String digested = this.digest(authentication);
            Object object = this.lock;
            synchronized (object) {
                if (!this.hashedAuth2Encrypted.containsKey(digested)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                encrypted = this.hashedAuth2Encrypted.get(digested);
            }
            AergoKey decrypted = AergoKey.of((EncryptedPrivateKey)encrypted, (String)authentication.getPassword());
            return decrypted.export(password);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> listIdentities() {
        try {
            ArrayList<Identity> identities;
            Object object = this.lock;
            synchronized (object) {
                identities = new ArrayList<Identity>(this.storedIdentities);
            }
            return identities;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public void store(String path, char[] password) {
    }

    protected String digest(Authentication authentication) {
        byte[] rawIdentity = authentication.getIdentity().getValue().getBytes();
        byte[] rawPassword = authentication.getPassword().getBytes();
        byte[] plaintext = new byte[rawIdentity.length + rawPassword.length];
        System.arraycopy(rawIdentity, 0, plaintext, 0, rawIdentity.length);
        System.arraycopy(rawPassword, 0, plaintext, rawIdentity.length, rawPassword.length);
        return new String(Sha256Utils.digest((byte[])plaintext));
    }
}

