/*
 * Decompiled with CFR 0.152.
 */
package hera.keystore;

import hera.annotation.ApiAudience;
import hera.annotation.ApiStability;
import hera.api.model.Authentication;
import hera.api.model.EncryptedPrivateKey;
import hera.api.model.Identity;
import hera.exception.HerajException;
import hera.exception.InvalidAuthenticationException;
import hera.key.AergoKey;
import hera.key.Signer;
import hera.keystore.AbstractKeyStore;
import hera.keystore.KeyStore;
import hera.model.KeyAlias;
import hera.util.ValidationUtils;
import hera.util.pki.ECDSAKey;
import hera.util.pki.ECDSAKeyGenerator;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.Arrays;

@ApiAudience.Private
@ApiStability.Unstable
public class JavaKeyStore
extends AbstractKeyStore
implements KeyStore {
    protected final Object lock = new Object();
    protected final Provider bcProvider = new BouncyCastleProvider();
    protected final java.security.KeyStore delegate;

    public JavaKeyStore(java.security.KeyStore delegate) {
        ValidationUtils.assertNotNull((Object)delegate, (String)"java.security.KeyStore must not null");
        this.logger.debug("Create a JavaKeyStore with delegate: {}", (Object)delegate);
        this.delegate = delegate;
    }

    @Deprecated
    public JavaKeyStore(String type) {
        this(type, null, null);
    }

    @Deprecated
    public JavaKeyStore(String type, Provider provider) {
        this(type, provider, null, null);
    }

    @Deprecated
    public JavaKeyStore(String type, InputStream inputStream, char[] password) {
        try {
            ValidationUtils.assertNotNull((Object)type, (String)"Keystore type must not null");
            this.logger.debug("Create JavaKeyStore with type: {}", (Object)type);
            this.delegate = java.security.KeyStore.getInstance(type);
            this.delegate.load(inputStream, password);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    public JavaKeyStore(String type, Provider provider, InputStream inputStream, char[] password) {
        try {
            ValidationUtils.assertNotNull((Object)type, (String)"Keystore type must not null");
            ValidationUtils.assertNotNull((Object)provider, (String)"Keystore provider must not null");
            this.logger.debug("Create JKS with type: {}, provider: {}", (Object)type, (Object)provider);
            this.delegate = java.security.KeyStore.getInstance(type, provider);
            this.delegate.load(inputStream, password);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Authentication authentication, AergoKey key) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            ValidationUtils.assertNotNull((Object)key, (String)"Key must not null");
            this.logger.debug("Save with authentication: {}, key: {}", (Object)authentication, (Object)key.getAddress());
            Object object = this.lock;
            synchronized (object) {
                if (this.isExists(authentication)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                String alias = authentication.getIdentity().getValue();
                PrivateKey privateKey = key.getPrivateKey();
                char[] rawPassword = authentication.getPassword().toCharArray();
                Certificate cert = this.generateCertificate(key);
                Certificate[] certChain = new Certificate[]{cert};
                this.delegate.setKeyEntry(alias, privateKey, rawPassword, certChain);
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    protected Certificate generateCertificate(AergoKey key) throws OperatorCreationException, CertificateException {
        this.logger.trace("Generate certificate for account: {}", (Object)key.getAddress());
        Calendar start = Calendar.getInstance();
        Calendar expiry = Calendar.getInstance();
        expiry.add(1, 1);
        this.logger.trace("Start: {}, expiry: {}", (Object)start, (Object)expiry);
        X500Name name = new X500Name("CN=" + key.getAddress().getValue());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithECDSA").setProvider(this.bcProvider).build(key.getPrivateKey());
        X509CertificateHolder holder = new X509v3CertificateBuilder(name, BigInteger.ONE, start.getTime(), expiry.getTime(), name, SubjectPublicKeyInfo.getInstance((Object)key.getPublicKey().getEncoded())).build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(this.bcProvider).getCertificate(holder);
        this.logger.trace("Generated certificate: {}", (Object)cert);
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Signer load(Authentication authentication) {
        try {
            Key rawKey;
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Load with authentication: {}", (Object)authentication);
            Object object = this.lock;
            synchronized (object) {
                if (!this.isExists(authentication)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                rawKey = this.loadRawKey(authentication);
            }
            AergoKey aergoKey = this.convertPrivateKey(rawKey);
            this.logger.trace("Loaded key: {}", (Object)aergoKey);
            return aergoKey;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Authentication authentication) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Remove with authentication: {}", (Object)authentication);
            Object object = this.lock;
            synchronized (object) {
                if (!this.isExists(authentication)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                Identity identity = authentication.getIdentity();
                this.delegate.deleteEntry(identity.getValue());
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptedPrivateKey export(Authentication authentication, String password) {
        try {
            Key rawKey;
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            ValidationUtils.assertNotNull((Object)password, (String)"Password must not null");
            this.logger.debug("Export with authentication: {}, password: ***", (Object)authentication);
            Object object = this.lock;
            synchronized (object) {
                if (!this.isExists(authentication)) {
                    throw new InvalidAuthenticationException("Invalid authentication");
                }
                rawKey = this.loadRawKey(authentication);
            }
            AergoKey decrypted = this.convertPrivateKey(rawKey);
            return decrypted.export(password);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> listIdentities() {
        try {
            ArrayList<String> aliases;
            Object object = this.lock;
            synchronized (object) {
                aliases = Collections.list(this.delegate.aliases());
                this.logger.trace("Aliases: {}", aliases);
            }
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (String alias : aliases) {
                identities.add(KeyAlias.of(alias));
            }
            return identities;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String path, char[] password) {
        ValidationUtils.assertNotNull((Object)path, (String)"Store path must not null");
        ValidationUtils.assertNotNull((Object)password, (String)"Store password must not null");
        try (FileOutputStream os = new FileOutputStream(path);){
            this.logger.debug("Save JKS to path: {}", (Object)path);
            Object object = this.lock;
            synchronized (object) {
                this.delegate.store(os, password);
            }
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    protected boolean isExists(Authentication authentication) throws Exception {
        String alias = authentication.getIdentity().getValue();
        if (this.delegate.containsAlias(alias)) {
            return true;
        }
        try {
            Key rawKey = this.loadRawKey(authentication);
            return null != rawKey;
        }
        catch (UnrecoverableKeyException e) {
            return false;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected Key loadRawKey(Authentication authentication) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        String alias = authentication.getIdentity().getValue();
        char[] rawPassword = authentication.getPassword().toCharArray();
        Key rawKey = this.delegate.getKey(alias, rawPassword);
        Arrays.fill((char[])rawPassword, (char)'0');
        return rawKey;
    }

    protected AergoKey convertPrivateKey(Key privateKey) throws Exception {
        BigInteger d;
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            d = ((java.security.interfaces.ECPrivateKey)privateKey).getS();
        } else if (privateKey instanceof ECPrivateKey) {
            d = ((ECPrivateKey)privateKey).getD();
        } else {
            throw new UnsupportedOperationException("Unacceptable key type: " + privateKey.getClass().getName());
        }
        ECDSAKey ecdsakey = new ECDSAKeyGenerator().create(d);
        return new AergoKey(ecdsakey);
    }
}

