/*
 * Decompiled with CFR 0.152.
 */
package hera.model;

import hera.annotation.ApiAudience;
import hera.annotation.ApiStability;
import hera.api.model.Identity;
import hera.exception.HerajException;
import hera.util.ValidationUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ApiAudience.Public
@ApiStability.Unstable
public class KeyAlias
implements Identity {
    protected static final Pattern ALIAS_PATTERN = Pattern.compile("[a-zA-Z0-9]+");
    protected final String value;

    public static KeyAlias of(String value) {
        return new KeyAlias(value);
    }

    public KeyAlias(String value) {
        ValidationUtils.assertNotNull((Object)value);
        Matcher matcher = ALIAS_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new HerajException("Key alias must be " + ALIAS_PATTERN.toString());
        }
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyAlias)) {
            return false;
        }
        KeyAlias other = (KeyAlias)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyAlias;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String getValue() {
        return this.value;
    }
}

