/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.api.model.Account;
import hera.api.model.AccountAddress;
import hera.api.model.AccountFactory;
import hera.api.model.AccountState;
import hera.api.model.AccountTotalVote;
import hera.api.model.Aer;
import hera.api.model.Authentication;
import hera.api.model.Block;
import hera.api.model.BlockHash;
import hera.api.model.BlockMetadata;
import hera.api.model.BlockchainStatus;
import hera.api.model.BytesValue;
import hera.api.model.ChainIdHash;
import hera.api.model.ChainInfo;
import hera.api.model.ChainStats;
import hera.api.model.ContractAddress;
import hera.api.model.ContractDefinition;
import hera.api.model.ContractInterface;
import hera.api.model.ContractInvocation;
import hera.api.model.ContractResult;
import hera.api.model.ContractTxHash;
import hera.api.model.ContractTxReceipt;
import hera.api.model.ElectedCandidate;
import hera.api.model.Event;
import hera.api.model.EventFilter;
import hera.api.model.Fee;
import hera.api.model.Identity;
import hera.api.model.Name;
import hera.api.model.NodeStatus;
import hera.api.model.Peer;
import hera.api.model.PeerMetric;
import hera.api.model.RawTransaction;
import hera.api.model.ServerInfo;
import hera.api.model.StakeInfo;
import hera.api.model.StreamObserver;
import hera.api.model.Subscription;
import hera.api.model.Transaction;
import hera.api.model.TxHash;
import hera.exception.HerajException;
import hera.exception.InvalidAuthenticationException;
import hera.exception.WalletExceptionConverter;
import hera.key.AergoKey;
import hera.key.AergoSignVerifier;
import hera.key.TxSigner;
import hera.keystore.JavaKeyStore;
import hera.util.ExceptionConverter;
import hera.util.ValidationUtils;
import hera.wallet.PreparedWalletApiImpl;
import hera.wallet.Wallet;
import hera.wallet.WalletApiFactory;
import hera.wallet.WalletApiImpl;
import hera.wallet.WalletType;
import java.security.KeyStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyWallet
implements Wallet {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ExceptionConverter<HerajException> exceptionConverter = new WalletExceptionConverter();
    protected final WalletType type;
    protected WalletApiImpl walletApiImpl;
    protected PreparedWalletApiImpl preparedWalletApiImpl;

    @Override
    public Account getAccount() {
        return new AccountFactory().create(this.walletApiImpl.getPrincipal(), (TxSigner)this.walletApiImpl);
    }

    @Override
    public AccountTotalVote getVotes() {
        return this.preparedWalletApiImpl.query().getVotesOf(this.walletApiImpl.getPrincipal());
    }

    @Override
    public long getRecentlyUsedNonce() {
        return this.getAccountState().getNonce();
    }

    @Override
    public long incrementAndGetNonce() {
        return this.getAccountState().getNonce() + 1L;
    }

    @Override
    public void bindKeyStore(KeyStore keyStore) {
        if (this.type.equals((Object)WalletType.Secure)) {
            this.walletApiImpl = (WalletApiImpl)new WalletApiFactory().create(new JavaKeyStore(keyStore));
            this.preparedWalletApiImpl = (PreparedWalletApiImpl)this.walletApiImpl.with(this.preparedWalletApiImpl.aergoClient);
        }
    }

    @Override
    public void saveKey(AergoKey key, String password) {
        this.saveKey(key, (Identity)key.getAddress(), password);
    }

    @Override
    public void saveKey(AergoKey key, Identity identity, String password) {
        this.walletApiImpl.keyStore.save(Authentication.of((Identity)identity, (String)password), key);
    }

    @Override
    public String exportKey(Authentication authentication) {
        return this.walletApiImpl.keyStore.export(authentication, authentication.getPassword()).getEncoded();
    }

    @Override
    public List<Identity> listKeyStoreIdentities() {
        return this.walletApiImpl.keyStore.listIdentities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(Authentication authentication) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            Object object = this.walletApiImpl.lock;
            synchronized (object) {
                this.walletApiImpl.proxySigner.setUnlocked(this.walletApiImpl.keyStore.load(authentication));
            }
            return true;
        }
        catch (InvalidAuthenticationException e) {
            return false;
        }
        catch (Exception e) {
            throw (HerajException)this.exceptionConverter.convert((Throwable)e);
        }
    }

    @Override
    public boolean lock(Authentication authentication) {
        try {
            return this.walletApiImpl.lock();
        }
        catch (Exception e) {
            throw (HerajException)this.exceptionConverter.convert((Throwable)e);
        }
    }

    @Override
    public void storeKeyStore(String path, String password) {
        try {
            if (this.walletApiImpl.keyStore instanceof JavaKeyStore) {
                this.walletApiImpl.keyStore.store(path, password.toCharArray());
            }
        }
        catch (Exception e) {
            throw new HerajException((Throwable)e);
        }
    }

    @Override
    public AccountState getAccountState() {
        return this.preparedWalletApiImpl.query().getAccountState(this.walletApiImpl.getPrincipal());
    }

    @Override
    public AccountState getAccountState(Account account) {
        return this.preparedWalletApiImpl.query().getAccountState(account.getAddress());
    }

    @Override
    public AccountState getAccountState(AccountAddress accountAddress) {
        return this.preparedWalletApiImpl.query().getAccountState(accountAddress);
    }

    @Override
    public AccountAddress getNameOwner(String name) {
        return this.preparedWalletApiImpl.query().getNameOwner(Name.of((String)name));
    }

    @Override
    public AccountAddress getNameOwner(String name, long blockNumber) {
        return this.preparedWalletApiImpl.query().getNameOwner(Name.of((String)name), blockNumber);
    }

    @Override
    public StakeInfo getStakingInfo() {
        return this.preparedWalletApiImpl.query().getStakeInfo(this.walletApiImpl.getPrincipal());
    }

    @Override
    public StakeInfo getStakingInfo(Account account) {
        return this.preparedWalletApiImpl.query().getStakeInfo(account.getAddress());
    }

    @Override
    public StakeInfo getStakingInfo(AccountAddress accountAddress) {
        return this.preparedWalletApiImpl.query().getStakeInfo(accountAddress);
    }

    @Override
    public List<ElectedCandidate> listElectedBps(int showCount) {
        return this.preparedWalletApiImpl.query().listElectedBps(showCount);
    }

    @Override
    public List<ElectedCandidate> listElected(String voteId, int showCount) {
        return this.preparedWalletApiImpl.query().listElected(voteId, showCount);
    }

    @Override
    public AccountTotalVote getVotesOf(Account account) {
        return this.preparedWalletApiImpl.query().getVotesOf(account.getAddress());
    }

    @Override
    public AccountTotalVote getVotesOf(AccountAddress accountAddress) {
        return this.preparedWalletApiImpl.query().getVotesOf(accountAddress);
    }

    @Override
    public List<AccountAddress> listServerKeyStoreAccounts() {
        return this.preparedWalletApiImpl.aergoClient.getKeyStoreOperation().list();
    }

    @Override
    public BlockHash getBestBlockHash() {
        return this.preparedWalletApiImpl.query().getBestBlockHash();
    }

    @Override
    public long getBestBlockHeight() {
        return this.preparedWalletApiImpl.query().getBestBlockHeight();
    }

    @Override
    public ChainIdHash getChainIdHash() {
        return this.preparedWalletApiImpl.query().getChainIdHash();
    }

    @Override
    public BlockchainStatus getBlockchainStatus() {
        return this.preparedWalletApiImpl.query().getBlockchainStatus();
    }

    @Override
    public ChainInfo getChainInfo() {
        return this.preparedWalletApiImpl.query().getChainInfo();
    }

    @Override
    public ChainStats getChainStats() {
        return this.preparedWalletApiImpl.query().getChainStats();
    }

    @Override
    public List<Peer> listNodePeers() {
        return this.preparedWalletApiImpl.query().listPeers();
    }

    @Override
    public List<PeerMetric> listPeerMetrics() {
        return this.preparedWalletApiImpl.query().listPeerMetrics();
    }

    @Override
    public ServerInfo getServerInfo(List<String> categories) {
        return this.preparedWalletApiImpl.query().getServerInfo(categories);
    }

    @Override
    public NodeStatus getNodeStatus() {
        return this.preparedWalletApiImpl.query().getNodeStatus();
    }

    @Override
    public BlockMetadata getBlockMetadata(BlockHash blockHash) {
        return this.preparedWalletApiImpl.query().getBlockMetadata(blockHash);
    }

    @Override
    public BlockMetadata getBlockMetadata(long height) {
        return this.preparedWalletApiImpl.query().getBlockMetadata(height);
    }

    @Override
    public List<BlockMetadata> listBlockMetadatas(BlockHash blockHash, int size) {
        return this.preparedWalletApiImpl.query().listBlockMetadatas(blockHash, size);
    }

    @Override
    public List<BlockMetadata> listBlockMetadatas(long height, int size) {
        return this.preparedWalletApiImpl.query().listBlockMetadatas(height, size);
    }

    @Override
    public Block getBlock(BlockHash blockHash) {
        return this.preparedWalletApiImpl.query().getBlock(blockHash);
    }

    @Override
    public Block getBlock(long height) {
        return this.preparedWalletApiImpl.query().getBlock(height);
    }

    @Override
    public Subscription<BlockMetadata> subscribeNewBlockMetadata(StreamObserver<BlockMetadata> observer) {
        return this.preparedWalletApiImpl.query().subscribeBlockMetadata(observer);
    }

    @Override
    public Subscription<Block> subscribeNewBlock(StreamObserver<Block> observer) {
        return this.preparedWalletApiImpl.query().subscribeBlock(observer);
    }

    @Override
    public Transaction getTransaction(TxHash txHash) {
        return this.preparedWalletApiImpl.query().getTransaction(txHash);
    }

    @Override
    public ContractTxReceipt getReceipt(ContractTxHash contractTxHash) {
        return this.preparedWalletApiImpl.query().getContractTxReceipt((TxHash)contractTxHash);
    }

    @Override
    public ContractInterface getContractInterface(ContractAddress contractAddress) {
        return this.preparedWalletApiImpl.query().getContractInterface(contractAddress);
    }

    @Override
    public ContractResult query(ContractInvocation contractInvocation) {
        return this.preparedWalletApiImpl.query().queryContract(contractInvocation);
    }

    @Override
    public List<Event> listEvents(EventFilter filter) {
        return this.preparedWalletApiImpl.query().listEvents(filter);
    }

    @Override
    public Subscription<Event> subscribeEvent(EventFilter filter, StreamObserver<Event> observer) {
        return this.preparedWalletApiImpl.query().subscribeEvent(filter, observer);
    }

    @Override
    public ChainIdHash getCachedChainIdHash() {
        return this.preparedWalletApiImpl.aergoClient.getCachedChainIdHash();
    }

    @Override
    public void cacheChainIdHash() {
        ChainIdHash chainIdHash = this.preparedWalletApiImpl.aergoClient.getBlockchainOperation().getChainIdHash();
        this.preparedWalletApiImpl.aergoClient.cacheChainIdHash(chainIdHash);
    }

    @Override
    public void cacheChainIdHash(ChainIdHash chainIdHash) {
        this.preparedWalletApiImpl.aergoClient.cacheChainIdHash(chainIdHash);
    }

    @Override
    public Account loadAccount(Authentication authentication) {
        this.unlock(authentication);
        return this.getAccount();
    }

    @Override
    public Transaction sign(RawTransaction rawTransaction) {
        return this.walletApiImpl.sign(rawTransaction);
    }

    @Override
    public boolean verify(Transaction transaction) {
        try {
            this.logger.debug("Verify signed transaction {}", (Object)transaction);
            AergoSignVerifier verifier = new AergoSignVerifier();
            return verifier.verify(transaction);
        }
        catch (Exception e) {
            throw (HerajException)this.exceptionConverter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash createName(String name) {
        return this.preparedWalletApiImpl.transaction().createName(Name.of((String)name));
    }

    @Override
    public TxHash updateName(String name, AccountAddress newOwner) {
        return this.preparedWalletApiImpl.transaction().updateName(Name.of((String)name), newOwner);
    }

    @Override
    public TxHash stake(Aer amount) {
        return this.preparedWalletApiImpl.transaction().stake(amount);
    }

    @Override
    public TxHash unstake(Aer amount) {
        return this.preparedWalletApiImpl.transaction().stake(amount);
    }

    @Override
    public TxHash voteBp(List<String> candidates) {
        return this.preparedWalletApiImpl.transaction().voteBp(candidates);
    }

    @Override
    public TxHash vote(String voteId, List<String> candidates) {
        return this.preparedWalletApiImpl.transaction().vote(voteId, candidates);
    }

    @Override
    public TxHash send(String recipient, Aer amount) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, Fee.ZERO);
    }

    @Override
    public TxHash send(String recipient, Aer amount, Fee fee) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, fee);
    }

    @Override
    public TxHash send(String recipient, Aer amount, BytesValue payload) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, Fee.ZERO, payload);
    }

    @Override
    public TxHash send(String recipient, Aer amount, Fee fee, BytesValue payload) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, fee, payload);
    }

    @Override
    public TxHash send(AccountAddress recipient, Aer amount) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, Fee.ZERO);
    }

    @Override
    public TxHash send(AccountAddress recipient, Aer amount, Fee fee) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, fee);
    }

    @Override
    public TxHash send(AccountAddress recipient, Aer amount, BytesValue payload) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, Fee.ZERO, payload);
    }

    @Override
    public TxHash send(AccountAddress recipient, Aer amount, Fee fee, BytesValue payload) {
        return this.preparedWalletApiImpl.transaction().send(recipient, amount, fee, payload);
    }

    @Override
    public TxHash commit(RawTransaction rawTransaction) {
        return this.preparedWalletApiImpl.transaction().commit(rawTransaction);
    }

    @Override
    public TxHash commit(Transaction signedTransaction) {
        return this.preparedWalletApiImpl.transaction().commit(signedTransaction);
    }

    @Override
    public ContractTxHash deploy(ContractDefinition contractDefinition) {
        return (ContractTxHash)this.preparedWalletApiImpl.transaction().deploy(contractDefinition, Fee.ZERO).adapt(ContractTxHash.class);
    }

    @Override
    public ContractTxHash deploy(ContractDefinition contractDefinition, Fee fee) {
        return (ContractTxHash)this.preparedWalletApiImpl.transaction().deploy(contractDefinition, fee).adapt(ContractTxHash.class);
    }

    @Override
    public ContractTxHash execute(ContractInvocation contractInvocation) {
        return (ContractTxHash)this.preparedWalletApiImpl.transaction().execute(contractInvocation, Fee.ZERO).adapt(ContractTxHash.class);
    }

    @Override
    public ContractTxHash execute(ContractInvocation contractInvocation, Fee fee) {
        return (ContractTxHash)this.preparedWalletApiImpl.transaction().execute(contractInvocation, fee).adapt(ContractTxHash.class);
    }

    @Override
    public void close() {
        this.preparedWalletApiImpl.aergoClient.close();
    }

    public LegacyWallet(WalletType type, WalletApiImpl walletApiImpl, PreparedWalletApiImpl preparedWalletApiImpl) {
        this.type = type;
        this.walletApiImpl = walletApiImpl;
        this.preparedWalletApiImpl = preparedWalletApiImpl;
    }
}

