/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.api.model.AccountAddress;
import hera.api.model.BytesValue;
import hera.api.model.Hash;
import hera.api.model.RawTransaction;
import hera.api.model.Signature;
import hera.api.model.Transaction;
import hera.exception.HerajException;
import hera.key.Signer;
import hera.util.ValidationUtils;
import hera.wallet.LockableCabinet;

class ProxySigner
implements Signer,
LockableCabinet<Signer> {
    protected Signer delegate;

    ProxySigner() {
    }

    public Transaction sign(RawTransaction rawTransaction) {
        ValidationUtils.assertNotNull((Object)rawTransaction, (String)"Raw transaction must not null");
        Signer unlocked = this.getUnlocked();
        if (!unlocked.getPrincipal().equals((Object)rawTransaction.getSender())) {
            throw new HerajException("Sender of the rawTransaction should equals with signer");
        }
        return unlocked.sign(rawTransaction);
    }

    public Signature signMessage(BytesValue message) {
        ValidationUtils.assertNotNull((Object)message, (String)"Message must not null");
        Signer unlocked = this.getUnlocked();
        return unlocked.signMessage(message);
    }

    public Signature signMessage(Hash hashedMessage) {
        ValidationUtils.assertNotNull((Object)hashedMessage, (String)"Hashed message must not null");
        Signer unlocked = this.getUnlocked();
        return unlocked.signMessage(hashedMessage);
    }

    public AccountAddress getPrincipal() {
        Signer unlocked = this.getUnlocked();
        return unlocked.getPrincipal();
    }

    @Override
    public Signer getUnlocked() {
        if (null == this.delegate) {
            throw new HerajException("Unlock account first");
        }
        return this.delegate;
    }

    @Override
    public void setUnlocked(Signer signer) {
        ValidationUtils.assertNotNull((Object)signer, (String)"Signer must not null");
        this.delegate = signer;
    }

    @Override
    public boolean lock() {
        if (null == this.delegate) {
            return false;
        }
        this.delegate = null;
        return true;
    }

    @Override
    public boolean isUnlocked() {
        return null != this.delegate;
    }
}

