/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.api.model.AccountAddress;
import hera.api.model.AccountState;
import hera.api.model.AccountTotalVote;
import hera.api.model.Block;
import hera.api.model.BlockHash;
import hera.api.model.BlockMetadata;
import hera.api.model.BlockchainStatus;
import hera.api.model.ChainIdHash;
import hera.api.model.ChainInfo;
import hera.api.model.ChainStats;
import hera.api.model.ContractAddress;
import hera.api.model.ContractInterface;
import hera.api.model.ContractInvocation;
import hera.api.model.ContractResult;
import hera.api.model.ContractTxReceipt;
import hera.api.model.ElectedCandidate;
import hera.api.model.Event;
import hera.api.model.EventFilter;
import hera.api.model.Name;
import hera.api.model.NodeStatus;
import hera.api.model.Peer;
import hera.api.model.PeerMetric;
import hera.api.model.ServerInfo;
import hera.api.model.StakeInfo;
import hera.api.model.StreamObserver;
import hera.api.model.Subscription;
import hera.api.model.Transaction;
import hera.api.model.TxHash;
import hera.api.model.TxReceipt;
import hera.client.AergoClient;
import hera.exception.HerajException;
import hera.wallet.AbstractApi;
import hera.wallet.ClientProvider;
import hera.wallet.QueryApi;
import java.util.List;
import lombok.NonNull;

class QueryApiImpl
extends AbstractApi
implements QueryApi {
    @NonNull
    protected final ClientProvider clientProvider;

    @Override
    public AccountState getAccountState(AccountAddress accountAddress) {
        try {
            return this.getClient().getAccountOperation().getState(accountAddress);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public AccountAddress getNameOwner(String name) {
        return this.getNameOwner(Name.of((String)name));
    }

    @Override
    public AccountAddress getNameOwner(Name name) {
        try {
            return this.getClient().getAccountOperation().getNameOwner(name);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public AccountAddress getNameOwner(String name, long blockNumber) {
        return this.getNameOwner(Name.of((String)name), blockNumber);
    }

    @Override
    public AccountAddress getNameOwner(Name name, long blockNumber) {
        try {
            return this.getClient().getAccountOperation().getNameOwner(name, blockNumber);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public StakeInfo getStakingInfo(AccountAddress accountAddress) {
        return this.getStakeInfo(accountAddress);
    }

    @Override
    public StakeInfo getStakeInfo(AccountAddress accountAddress) {
        try {
            return this.getClient().getAccountOperation().getStakeInfo(accountAddress);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<ElectedCandidate> listElectedBps(int showCount) {
        try {
            return this.getClient().getAccountOperation().listElected("voteBP", showCount);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<ElectedCandidate> listElected(String voteId, int showCount) {
        try {
            return this.getClient().getAccountOperation().listElected(voteId, showCount);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public AccountTotalVote getVotesOf(AccountAddress accountAddress) {
        try {
            return this.getClient().getAccountOperation().getVotesOf(accountAddress);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public BlockHash getBestBlockHash() {
        try {
            return this.getClient().getBlockchainOperation().getBlockchainStatus().getBestBlockHash();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public long getBestBlockHeight() {
        try {
            return this.getClient().getBlockchainOperation().getBlockchainStatus().getBestHeight();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ChainIdHash getChainIdHash() {
        try {
            return this.getClient().getBlockchainOperation().getBlockchainStatus().getChainIdHash();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public BlockchainStatus getBlockchainStatus() {
        try {
            return this.getClient().getBlockchainOperation().getBlockchainStatus();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ChainInfo getChainInfo() {
        try {
            return this.getClient().getBlockchainOperation().getChainInfo();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ChainStats getChainStats() {
        try {
            return this.getClient().getBlockchainOperation().getChainStats();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<Peer> listPeers() {
        try {
            return this.getClient().getBlockchainOperation().listPeers();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<Peer> listPeers(boolean showHidden, boolean showSelf) {
        try {
            return this.getClient().getBlockchainOperation().listPeers(showHidden, showSelf);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<PeerMetric> listPeerMetrics() {
        try {
            return this.getClient().getBlockchainOperation().listPeerMetrics();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ServerInfo getServerInfo(List<String> categories) {
        try {
            return this.getClient().getBlockchainOperation().getServerInfo(categories);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public NodeStatus getNodeStatus() {
        try {
            return this.getClient().getBlockchainOperation().getNodeStatus();
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public BlockMetadata getBlockMetadata(BlockHash blockHash) {
        try {
            return this.getClient().getBlockOperation().getBlockMetadata(blockHash);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public BlockMetadata getBlockMetadata(long height) {
        try {
            return this.getClient().getBlockOperation().getBlockMetadata(height);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<BlockMetadata> listBlockMetadatas(BlockHash blockHash, int size) {
        try {
            return this.getClient().getBlockOperation().listBlockMetadatas(blockHash, size);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<BlockMetadata> listBlockMetadatas(long height, int size) {
        try {
            return this.getClient().getBlockOperation().listBlockMetadatas(height, size);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public Block getBlock(BlockHash blockHash) {
        try {
            return this.getClient().getBlockOperation().getBlock(blockHash);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public Block getBlock(long height) {
        try {
            return this.getClient().getBlockOperation().getBlock(height);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public Subscription<BlockMetadata> subscribeNewBlockMetadata(StreamObserver<BlockMetadata> observer) {
        return this.subscribeBlockMetadata(observer);
    }

    @Override
    public Subscription<Block> subscribeNewBlock(StreamObserver<Block> observer) {
        return this.subscribeBlock(observer);
    }

    @Override
    public Subscription<BlockMetadata> subscribeBlockMetadata(StreamObserver<BlockMetadata> observer) {
        try {
            return this.getClient().getBlockOperation().subscribeBlockMetadata(observer);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public Subscription<Block> subscribeBlock(StreamObserver<Block> observer) {
        try {
            return this.getClient().getBlockOperation().subscribeBlock(observer);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public Transaction getTransaction(TxHash txHash) {
        try {
            return this.getClient().getTransactionOperation().getTransaction(txHash);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxReceipt getTxReceipt(TxHash txHash) {
        try {
            return this.getClient().getTransactionOperation().getTxReceipt(txHash);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ContractTxReceipt getContractTxReceipt(TxHash contractTxHash) {
        try {
            return this.getClient().getContractOperation().getContractTxReceipt(contractTxHash);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ContractInterface getContractInterface(ContractAddress contractAddress) {
        try {
            return this.getClient().getContractOperation().getContractInterface(contractAddress);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public ContractResult query(ContractInvocation contractInvocation) {
        return this.queryContract(contractInvocation);
    }

    @Override
    public ContractResult queryContract(ContractInvocation contractInvocation) {
        try {
            return this.getClient().getContractOperation().query(contractInvocation);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public List<Event> listEvents(EventFilter filter) {
        try {
            return this.getClient().getContractOperation().listEvents(filter);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public Subscription<Event> subscribeEvent(EventFilter filter, StreamObserver<Event> observer) {
        try {
            return this.getClient().getContractOperation().subscribeEvent(filter, observer);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    protected AergoClient getClient() {
        return this.clientProvider.getClient();
    }

    QueryApiImpl(@NonNull ClientProvider clientProvider) {
        if (clientProvider == null) {
            throw new NullPointerException("clientProvider is marked non-null but is null");
        }
        this.clientProvider = clientProvider;
    }
}

