/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.api.model.AccountAddress;
import hera.api.model.Aer;
import hera.api.model.BytesValue;
import hera.api.model.ContractAddress;
import hera.api.model.ContractDefinition;
import hera.api.model.ContractInvocation;
import hera.api.model.Fee;
import hera.api.model.Name;
import hera.api.model.RawTransaction;
import hera.api.model.Transaction;
import hera.api.model.TxHash;
import hera.client.AergoClient;
import hera.client.TxRequestFunction;
import hera.client.TxRequester;
import hera.exception.HerajException;
import hera.key.Signer;
import hera.wallet.AbstractApi;
import hera.wallet.ClientProvider;
import hera.wallet.TransactionApi;
import java.util.List;
import lombok.NonNull;

class TransactionApiImpl
extends AbstractApi
implements TransactionApi {
    @NonNull
    protected final ClientProvider clientProvider;
    @NonNull
    protected final Signer signer;
    @NonNull
    protected final TxRequester txRequester;

    @Override
    public TxHash createName(String name) {
        return this.createName(Name.of((String)name));
    }

    @Override
    public TxHash createName(final Name name) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getAccountOperation().createNameTx(signer, name, t.longValue());
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash updateName(String name, AccountAddress newOwner) {
        return this.updateName(Name.of((String)name), newOwner);
    }

    @Override
    public TxHash updateName(final Name name, final AccountAddress newOwner) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getAccountOperation().updateNameTx(signer, name, newOwner, t.longValue());
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash stake(final Aer amount) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getAccountOperation().stakeTx(signer, amount, t.longValue());
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash unstake(final Aer amount) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getAccountOperation().unstakeTx(signer, amount, t.longValue());
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash voteBp(List<String> candidates) {
        return this.vote("voteBP", candidates);
    }

    @Override
    public TxHash vote(final String voteId, final List<String> candidates) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getAccountOperation().voteTx(signer, voteId, candidates, t.longValue());
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash send(AccountAddress recipient, Aer amount, Fee fee) {
        return this.send(recipient, amount, fee, BytesValue.EMPTY);
    }

    @Override
    public TxHash send(final AccountAddress recipient, final Aer amount, final Fee fee, final BytesValue payload) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getTransactionOperation().sendTx(signer, recipient, amount, t.longValue(), fee, payload);
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash send(String recipient, Aer amount, Fee fee) {
        return this.send(Name.of((String)recipient), amount, fee, BytesValue.EMPTY);
    }

    @Override
    public TxHash send(String recipient, Aer amount, Fee fee, BytesValue payload) {
        return this.send(Name.of((String)recipient), amount, fee, payload);
    }

    @Override
    public TxHash send(Name recipient, Aer amount, Fee fee) {
        return this.send(recipient, amount, fee, BytesValue.EMPTY);
    }

    @Override
    public TxHash send(final Name recipient, final Aer amount, final Fee fee, final BytesValue payload) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getTransactionOperation().sendTx(signer, recipient, amount, t.longValue(), fee, payload);
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash commit(final RawTransaction rawTransaction) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getTransactionOperation().commit(signer.sign(rawTransaction));
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash commit(final Transaction signedTransaction) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getTransactionOperation().commit(signedTransaction);
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash deploy(final ContractDefinition contractDefinition, final Fee fee) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getContractOperation().deployTx(signer, contractDefinition, t.longValue(), fee);
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash redeploy(final ContractAddress existingContract, final ContractDefinition contractDefinition, final Fee fee) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getContractOperation().redeployTx(signer, existingContract, contractDefinition, t.longValue(), fee);
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TxHash execute(final ContractInvocation contractInvocation, final Fee fee) {
        try {
            return this.txRequester.request(this.getClient(), this.getSigner(), new TxRequestFunction(){

                public TxHash apply(Signer signer, Long t) {
                    return TransactionApiImpl.this.getClient().getContractOperation().executeTx(signer, contractInvocation, t.longValue(), fee);
                }
            });
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    protected AergoClient getClient() {
        return this.clientProvider.getClient();
    }

    protected Signer getSigner() {
        return this.signer;
    }

    TransactionApiImpl(@NonNull ClientProvider clientProvider, @NonNull Signer signer, @NonNull TxRequester txRequester) {
        if (clientProvider == null) {
            throw new NullPointerException("clientProvider is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        if (txRequester == null) {
            throw new NullPointerException("txRequester is marked non-null but is null");
        }
        this.clientProvider = clientProvider;
        this.signer = signer;
        this.txRequester = txRequester;
    }
}

