/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.annotation.ApiAudience;
import hera.annotation.ApiStability;
import hera.api.model.Time;
import hera.api.model.TryCountAndInterval;
import hera.keystore.KeyStore;
import hera.util.ValidationUtils;
import hera.wallet.WalletApi;
import hera.wallet.WalletApiImpl;

@ApiAudience.Public
@ApiStability.Unstable
public class WalletApiFactory {
    public static final TryCountAndInterval DEFAULT_TRY_COUNT_AND_INTERVAL = TryCountAndInterval.of((int)3, (Time)Time.of((long)100L));

    public WalletApi create(KeyStore keyStore) {
        return this.create(keyStore, DEFAULT_TRY_COUNT_AND_INTERVAL);
    }

    public WalletApi create(KeyStore keyStore, int retryCount, long retryInterval) {
        return this.create(keyStore, TryCountAndInterval.of((int)retryCount, (Time)Time.of((long)retryInterval)));
    }

    public WalletApi create(KeyStore keyStore, TryCountAndInterval tryCountAndInterval) {
        ValidationUtils.assertNotNull((Object)keyStore, (String)"Keystore must not null");
        ValidationUtils.assertNotNull((Object)tryCountAndInterval, (String)"TryCountAndInterval must not null");
        return new WalletApiImpl(keyStore, tryCountAndInterval);
    }
}

