/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.api.model.AccountAddress;
import hera.api.model.Authentication;
import hera.api.model.BytesValue;
import hera.api.model.Hash;
import hera.api.model.RawTransaction;
import hera.api.model.Signature;
import hera.api.model.Transaction;
import hera.api.model.TryCountAndInterval;
import hera.api.transaction.NonceProvider;
import hera.api.transaction.SimpleNonceProvider;
import hera.client.AergoClient;
import hera.client.NonceRefreshingTxRequester;
import hera.client.TxRequester;
import hera.exception.HerajException;
import hera.exception.InvalidAuthenticationException;
import hera.key.Signer;
import hera.keystore.KeyStore;
import hera.util.ValidationUtils;
import hera.wallet.AbstractApi;
import hera.wallet.PreparedWalletApi;
import hera.wallet.PreparedWalletApiImpl;
import hera.wallet.ProxySigner;
import hera.wallet.QueryApi;
import hera.wallet.TransactionApi;
import hera.wallet.WalletApi;

class WalletApiImpl
extends AbstractApi
implements WalletApi,
Signer {
    protected final KeyStore keyStore;
    protected final NonceProvider nonceProvider;
    protected final TxRequester txRequester;
    protected final Object lock = new Object();
    protected final ProxySigner proxySigner = new ProxySigner();

    WalletApiImpl(KeyStore keyStore, TryCountAndInterval tryCountAndInterval) {
        ValidationUtils.assertNotNull((Object)keyStore, (String)"Keystore must not null");
        ValidationUtils.assertNotNull((Object)tryCountAndInterval, (String)"TryCountAndInterval must not null");
        this.keyStore = keyStore;
        this.nonceProvider = new SimpleNonceProvider();
        this.txRequester = new NonceRefreshingTxRequester(tryCountAndInterval, this.nonceProvider);
    }

    @Override
    public void bind(AergoClient aergoClient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedWalletApi with(AergoClient aergoClient) {
        ValidationUtils.assertNotNull((Object)aergoClient, (String)"AergoClient must not null");
        return new PreparedWalletApiImpl(aergoClient, this.proxySigner, this.txRequester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(Authentication authentication) {
        try {
            ValidationUtils.assertNotNull((Object)authentication, (String)"Authentication must not null");
            this.logger.debug("Unlock with {}", (Object)authentication);
            Object object = this.lock;
            synchronized (object) {
                if (this.proxySigner.isUnlocked()) {
                    throw new HerajException("Lock already unlocked one");
                }
                this.proxySigner.setUnlocked(this.keyStore.load(authentication));
            }
            return true;
        }
        catch (InvalidAuthenticationException e) {
            return false;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public boolean lock(Authentication authentication) {
        return this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock() {
        try {
            this.logger.debug("Lock wallet api");
            Object object = this.lock;
            synchronized (object) {
                if (!this.proxySigner.isUnlocked()) {
                    return false;
                }
                this.proxySigner.lock();
            }
            return true;
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    @Override
    public TransactionApi transactionApi() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryApi queryApi() {
        throw new UnsupportedOperationException();
    }

    public Transaction sign(RawTransaction rawTransaction) {
        try {
            return this.proxySigner.sign(rawTransaction);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    public Signature signMessage(BytesValue message) {
        try {
            return this.proxySigner.signMessage(message);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    public Signature signMessage(Hash hashedMessage) {
        try {
            return this.proxySigner.signMessage(hashedMessage);
        }
        catch (Exception e) {
            throw (HerajException)this.converter.convert((Throwable)e);
        }
    }

    public AccountAddress getPrincipal() {
        return this.proxySigner.isUnlocked() ? this.proxySigner.getUnlocked().getPrincipal() : null;
    }

    public String toString() {
        return String.format("WalletApiImpl(keyStore=%s, principal=%s)", this.keyStore.getClass().getName(), this.getPrincipal());
    }
}

