/*
 * Decompiled with CFR 0.152.
 */
package hera.wallet;

import hera.annotation.ApiAudience;
import hera.annotation.ApiStability;
import hera.api.model.Time;
import hera.api.model.TryCountAndInterval;
import hera.client.AergoClient;
import hera.client.AergoClientBuilder;
import hera.client.ClientConfiguer;
import hera.keystore.InMemoryKeyStore;
import hera.wallet.LegacyWallet;
import hera.wallet.PreparedWalletApiImpl;
import hera.wallet.Wallet;
import hera.wallet.WalletApiFactory;
import hera.wallet.WalletApiImpl;
import hera.wallet.WalletType;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

@ApiAudience.Public
@ApiStability.Unstable
public class WalletBuilder
implements ClientConfiguer<WalletBuilder> {
    protected static final TryCountAndInterval MIMINUM_NONCE_REFRESH_COUNT = TryCountAndInterval.of((int)2, (Time)Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
    protected AergoClientBuilder clientBuilder = new AergoClientBuilder();
    protected TryCountAndInterval nonceRefreshTryInterval = MIMINUM_NONCE_REFRESH_COUNT;

    public WalletBuilder addConfiguration(String key, String value) {
        this.clientBuilder.addConfiguration(key, value);
        return this;
    }

    public WalletBuilder withEndpoint(String endpoint) {
        this.clientBuilder.withEndpoint(endpoint);
        return this;
    }

    public WalletBuilder withNonBlockingConnect() {
        this.clientBuilder.withNonBlockingConnect();
        return this;
    }

    public WalletBuilder withBlockingConnect() {
        this.clientBuilder.withBlockingConnect();
        return this;
    }

    public WalletBuilder withTimeout(long timeout, TimeUnit unit) {
        this.clientBuilder.withTimeout(timeout, unit);
        return this;
    }

    public WalletBuilder withRetry(int count, long interval, TimeUnit unit) {
        this.clientBuilder.withRetry(count, interval, unit);
        return this;
    }

    public WalletBuilder withPlainText() {
        this.clientBuilder.withPlainText();
        return this;
    }

    public WalletBuilder withTransportSecurity(String serverCommonName, String serverCertPath, String clientCertPath, String clientKeyPath) {
        this.clientBuilder.withTransportSecurity(serverCommonName, serverCertPath, clientCertPath, clientKeyPath);
        return this;
    }

    public WalletBuilder withTransportSecurity(String serverCommonName, InputStream serverCertInputStream, InputStream clientCertInputStream, InputStream clientKeyInputStream) {
        this.clientBuilder.withTransportSecurity(serverCommonName, serverCertInputStream, clientCertInputStream, clientKeyInputStream);
        return this;
    }

    public WalletBuilder withRefresh(int count, long interval, TimeUnit unit) {
        this.nonceRefreshTryInterval = TryCountAndInterval.of((int)(count <= 0 ? 1 : count), (Time)Time.of((long)(interval <= 0L ? 1L : interval), (TimeUnit)unit));
        return this;
    }

    public Wallet build(WalletType walletType) {
        AergoClient aergoClient = this.clientBuilder.build();
        if (walletType.equals((Object)WalletType.ServerKeyStore)) {
            throw new UnsupportedOperationException();
        }
        InMemoryKeyStore keyStore = new InMemoryKeyStore();
        WalletApiImpl delegate = (WalletApiImpl)new WalletApiFactory().create(keyStore, this.nonceRefreshTryInterval.getCount(), this.nonceRefreshTryInterval.getInterval().toMilliseconds());
        PreparedWalletApiImpl preparedWalletApi = (PreparedWalletApiImpl)delegate.with(aergoClient);
        return new LegacyWallet(walletType, delegate, preparedWalletApi);
    }
}

