/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.javaunit.autoparams.ArgumentsAssembler;
import org.javaunit.autoparams.ArgumentsProviderCreator;
import org.javaunit.autoparams.AutoArgumentsProvider;
import org.javaunit.autoparams.CsvAutoSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.support.AnnotationConsumer;

final class CsvAutoArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvAutoSource> {
    private final ArgumentsProvider csvProvider = ArgumentsProviderCreator.createProvider(CsvSource.class);
    private final AutoArgumentsProvider autoProvider = new AutoArgumentsProvider();

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        return ArgumentsAssembler.assembleArguments(context, this.csvProvider, this.autoProvider);
    }

    private static CsvSource createDelegate(final CsvAutoSource source) {
        return new CsvSource(){

            public Class<? extends Annotation> annotationType() {
                return CsvSource.class;
            }

            public String[] value() {
                return source.value();
            }

            public char delimiter() {
                return '\u0000';
            }

            public String delimiterString() {
                return "";
            }

            public String emptyValue() {
                return "";
            }

            public String[] nullValues() {
                return new String[0];
            }

            public int maxCharsPerColumn() {
                return 4096;
            }
        };
    }

    public void accept(CsvAutoSource annotation) {
        ((AnnotationConsumer)this.csvProvider).accept((Object)CsvAutoArgumentsProvider.createDelegate(annotation));
    }
}

