/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.customization;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectGenerator;

public class CompositeCustomizer
implements Customizer {
    private final Customizer[] customizers;

    public CompositeCustomizer(Customizer ... customizers) {
        this.customizers = customizers;
    }

    @Override
    public ObjectGenerator customize(ObjectGenerator generator) {
        return CompositeCustomizer.foldl(Arrays.stream(this.customizers), generator, (g, c) -> c.customize((ObjectGenerator)g));
    }

    private static <T, U> U foldl(Stream<T> xs, U z, BiFunction<U, T, U> f) {
        Iterator i = xs.iterator();
        U a = z;
        while (i.hasNext()) {
            a = f.apply(a, i.next());
        }
        return a;
    }
}

