/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.customization;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Predicate;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.customization.RuntimeTypeResolver;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;

public final class InstanceFieldWriter
implements Customizer {
    private final Class<?> targetType;
    private final Predicate<Field> predicate;

    public InstanceFieldWriter(Class<?> targetType) {
        this(targetType, x -> true);
    }

    private InstanceFieldWriter(Class<?> targetType, Predicate<Field> predicate) {
        this.targetType = targetType;
        this.predicate = predicate;
    }

    @Override
    public ObjectGenerator customize(ObjectGenerator generator) {
        return (query, context) -> {
            ObjectContainer container = generator.generate(query, context);
            Type underlyingType = query.getType();
            return this.getRawType(underlyingType) == this.targetType ? container.process(target -> this.process(target, underlyingType, context)) : container;
        };
    }

    private Class<?> getRawType(Type type) {
        return type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
    }

    private Object process(Object target, Type underlyingType, ObjectGenerationContext context) {
        this.writeAllFields(target, underlyingType, context);
        return target;
    }

    private void writeAllFields(Object target, Type underlyingType, ObjectGenerationContext context) {
        this.writeFields(target, underlyingType, context, RuntimeTypeResolver.create(underlyingType));
        Type superType = this.getRawType(underlyingType).getGenericSuperclass();
        if (superType != null) {
            this.writeAllFields(target, superType, context);
        }
    }

    private void writeFields(Object target, Type genericType, ObjectGenerationContext context, RuntimeTypeResolver typeResolver) {
        Arrays.stream(this.getRawType(genericType).getDeclaredFields()).filter(InstanceFieldWriter::isNonStatic).filter(this.predicate).forEach(field -> this.writeField(target, (Field)field, context, typeResolver));
    }

    private static boolean isNonStatic(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    private void writeField(Object target, Field field, ObjectGenerationContext context, RuntimeTypeResolver typeResolver) {
        field.setAccessible(true);
        Type type = typeResolver.resolve(field.getGenericType());
        Object argument = context.generate(() -> type);
        try {
            field.set(target, argument);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new RuntimeException(exception);
        }
    }

    public InstanceFieldWriter including(String ... fieldNames) {
        return new InstanceFieldWriter(this.targetType, this.predicate.and(field -> Arrays.stream(fieldNames).anyMatch(x -> field.getName().equals(x))));
    }

    public InstanceFieldWriter excluding(String ... fieldNames) {
        return new InstanceFieldWriter(this.targetType, this.predicate.and(field -> Arrays.stream(fieldNames).allMatch(x -> !field.getName().equals(x))));
    }
}

