/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import org.javaunit.autoparams.generator.EnumValuesResolver;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class EnumGenerator
implements ObjectGenerator {
    EnumGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        return type instanceof Class && Enum.class.isAssignableFrom((Class)type) ? new ObjectContainer(this.factory(query)) : ObjectContainer.EMPTY;
    }

    private Object factory(ObjectQuery query) {
        Class enumType = (Class)query.getType();
        Object[] values = EnumValuesResolver.resolveValues(enumType);
        int index = ThreadLocalRandom.current().nextInt(values.length);
        return values[index];
    }
}

