/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;
import org.javaunit.autoparams.generator.UnwrapFailedException;

public final class ObjectGenerationContext {
    private ObjectGenerator generator;

    public ObjectGenerationContext(ObjectGenerator generator) {
        this.generator = generator;
    }

    ObjectGenerator getGenerator() {
        return this.generator;
    }

    public Object generate(ObjectQuery query) {
        try {
            return this.generator.generate(query, this).unwrapOrElseThrow();
        }
        catch (UnwrapFailedException exception) {
            throw this.composeGenerationFailedException(query, exception);
        }
    }

    public <T> T generate(Class<T> type) {
        return (T)this.generate(() -> type);
    }

    private RuntimeException composeGenerationFailedException(ObjectQuery query, Throwable cause) {
        String messageFormat = "Object cannot be created with the given query '%s'. This can happen if the query represents an interface or abstract class.";
        String message = String.format(messageFormat, query);
        return new RuntimeException(message, cause);
    }

    public void customizeGenerator(Customizer customizer) {
        this.generator = customizer.customize(this.generator);
    }
}

