/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class OffsetDateTimeGenerator
implements ObjectGenerator {
    OffsetDateTimeGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        return query.getType().equals(OffsetDateTime.class) ? new ObjectContainer(this.factory(context)) : ObjectContainer.EMPTY;
    }

    private OffsetDateTime factory(ObjectGenerationContext context) {
        int bound = (int)TimeUnit.DAYS.toSeconds(7L);
        int seconds = ThreadLocalRandom.current().nextInt(bound);
        Clock clock = context.generate(Clock.class);
        return OffsetDateTime.now(clock).minusSeconds(seconds);
    }
}

