/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class SequenceGenerator
implements ObjectGenerator {
    private static final int SIZE = 3;

    SequenceGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        return query.getType() instanceof ParameterizedType ? this.generate((ParameterizedType)query.getType(), context) : ObjectContainer.EMPTY;
    }

    private ObjectContainer generate(ParameterizedType type, ObjectGenerationContext context) {
        return SequenceGenerator.isCollection((Class)type.getRawType()) ? new ObjectContainer(SequenceGenerator.factory(type.getActualTypeArguments()[0], context)) : ObjectContainer.EMPTY;
    }

    private static boolean isCollection(Class<?> type) {
        return type.equals(ArrayList.class) || type.equals(List.class) || type.equals(AbstractList.class) || type.equals(Collection.class) || type.equals(AbstractCollection.class) || type.equals(Iterable.class);
    }

    static <T> ArrayList<T> factory(Type elementType, ObjectGenerationContext context) {
        ArrayList<Object> instance = new ArrayList<Object>();
        ObjectQuery query = () -> elementType;
        for (int i = 0; i < 3; ++i) {
            instance.add(context.getGenerator().generate(query, context).unwrapOrElseThrow());
        }
        return instance;
    }
}

