/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Set;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class SetGenerator
implements ObjectGenerator {
    private static final int SIZE = 3;

    SetGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        return query.getType() instanceof ParameterizedType ? this.generate((ParameterizedType)query.getType(), context) : ObjectContainer.EMPTY;
    }

    private ObjectContainer generate(ParameterizedType type, ObjectGenerationContext context) {
        return this.isSet((Class)type.getRawType()) ? new ObjectContainer(SetGenerator.factory(type.getActualTypeArguments()[0], context)) : ObjectContainer.EMPTY;
    }

    private boolean isSet(Class<?> type) {
        return type.equals(HashSet.class) || type.equals(Set.class) || type.equals(AbstractSet.class);
    }

    public static <T> HashSet<T> factory(Type elementType, ObjectGenerationContext context) {
        HashSet<Object> instance = new HashSet<Object>();
        ObjectQuery query = () -> elementType;
        for (int i = 0; i < 3; ++i) {
            instance.add(context.getGenerator().generate(query, context).unwrapOrElseThrow());
        }
        return instance;
    }
}

