/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.ConstructorResolver;
import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.HighestPriorityPicker;
import io.github.thecodinglog.methodinvoker.ObjectFactory;
import io.github.thecodinglog.methodinvoker.ObjectInitializationException;
import io.github.thecodinglog.methodinvoker.PrioritizableMethodOrConstructorHolder;
import io.github.thecodinglog.methodinvoker.PublicOnlyCandidateConstructorsSelector;
import io.github.thecodinglog.methodinvoker.StrictConstructorResolver;
import io.github.thecodinglog.methodinvoker.TypeMatchableMethodArgumentBinder;
import java.lang.reflect.InvocationTargetException;

final class DefaultObjectFactory
implements ObjectFactory {
    private final ConstructorResolver constructorResolver;

    public DefaultObjectFactory(ConstructorResolver constructorResolver) {
        this.constructorResolver = constructorResolver;
    }

    public DefaultObjectFactory() {
        this.constructorResolver = new StrictConstructorResolver(new PublicOnlyCandidateConstructorsSelector(), new TypeMatchableMethodArgumentBinder(), new HighestPriorityPicker());
    }

    @Override
    public Object createObject(String fullQualifiedClassName, Context context) {
        Class<?> aClass;
        try {
            aClass = Class.forName(fullQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectInitializationException(e.getMessage(), e);
        }
        return this.createObject(aClass, context);
    }

    @Override
    public Object createObject(Class<?> clazz, Context context) {
        Object o;
        PrioritizableMethodOrConstructorHolder methodOrConstructorHolder = this.constructorResolver.resolve(clazz, context);
        try {
            o = methodOrConstructorHolder.constructor().newInstance(methodOrConstructorHolder.args());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ObjectInitializationException(e.getMessage(), e);
        }
        return o;
    }
}

