/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.Prioritizable;
import io.github.thecodinglog.methodinvoker.PriorityPicker;
import io.github.thecodinglog.methodinvoker.PriorityPickingException;
import java.util.List;

final class HighestPriorityPicker
implements PriorityPicker {
    HighestPriorityPicker() {
    }

    @Override
    public Prioritizable pick(List<? extends Prioritizable> object) {
        if (object == null) {
            throw new PriorityPickingException("Should not be null.");
        }
        if (object.size() == 0) {
            throw new PriorityPickingException("No objects to pick.");
        }
        if (object.size() == 1) {
            return object.get(0);
        }
        object.sort((o1, o2) -> {
            if (o1.priority() < o1.priority()) {
                return 1;
            }
            if (o1.priority() == o2.priority()) {
                return 0;
            }
            return -1;
        });
        if (object.get(0).priority() == object.get(1).priority()) {
            throw new PriorityPickingException("Ambiguous priority objects");
        }
        return object.get(0);
    }
}

