/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.MethodOrConstructorParameter;
import io.github.thecodinglog.methodinvoker.SpringMethodOrConstructorParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

final class MethodOrConstructor {
    private final Method method;
    private final Constructor<?> constructor;

    public MethodOrConstructor(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.method = method;
        this.constructor = null;
    }

    public MethodOrConstructor(Constructor<?> constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException();
        }
        this.method = null;
        this.constructor = constructor;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public MethodOrConstructorParameter parameter(int index) {
        if (this.method != null) {
            return new SpringMethodOrConstructorParameter(new MethodOrConstructor(this.method), index);
        }
        if (this.constructor != null) {
            return new SpringMethodOrConstructorParameter(new MethodOrConstructor(this.constructor), index);
        }
        throw new IllegalStateException("Method and Constructor are both null.");
    }

    public int parameterCount() {
        if (this.method != null) {
            return this.method.getParameterCount();
        }
        if (this.constructor != null) {
            return this.constructor.getParameterCount();
        }
        throw new IllegalStateException("Method and Constructor are both null.");
    }
}

