/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.MethodArgumentBindingStrategy;
import io.github.thecodinglog.methodinvoker.ParameterAndArgumentHolder;
import io.github.thecodinglog.methodinvoker.ParameterBindingResult;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterNameAndJsonMethodArgumentBindingStrategy
implements MethodArgumentBindingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ParameterNameAndJsonMethodArgumentBindingStrategy.class);

    @Override
    public ParameterBindingResult tryBind(ParameterAndArgumentHolder parameterAndArgumentHolder, Context context) {
        if (context.hasKey(parameterAndArgumentHolder.getParameterName())) {
            TypeDescribableObject argCandidate = context.getValueByKey(parameterAndArgumentHolder.getParameterName());
            Object paramObject = null;
            if (argCandidate.getObject() instanceof String) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    paramObject = objectMapper.readValue(argCandidate.getObject(String.class), (Class)parameterAndArgumentHolder.getParameterType());
                }
                catch (JsonProcessingException e) {
                    paramObject = null;
                }
            }
            if (paramObject != null && parameterAndArgumentHolder.canAccept(paramObject.getClass())) {
                parameterAndArgumentHolder.accept(new TypeDescribableObject(paramObject, parameterAndArgumentHolder.getParameterType()));
                log.debug("Parameter name json binding of {}", (Object)parameterAndArgumentHolder.getParameterName());
                return new ParameterBindingResult(parameterAndArgumentHolder, false);
            }
        }
        return new ParameterBindingResult(null, true);
    }
}

