/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.MethodArgumentBindingStrategy;
import io.github.thecodinglog.methodinvoker.ParameterAndArgumentHolder;
import io.github.thecodinglog.methodinvoker.ParameterBindingResult;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterNameMethodArgumentBindingStrategy
implements MethodArgumentBindingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ParameterNameMethodArgumentBindingStrategy.class);

    @Override
    public ParameterBindingResult tryBind(ParameterAndArgumentHolder parameterAndArgumentHolder, Context context) {
        if (context.hasKey(parameterAndArgumentHolder.getParameterName())) {
            TypeDescribableObject argCandidate = context.getValueByKey(parameterAndArgumentHolder.getParameterName());
            if (parameterAndArgumentHolder.canAccept(argCandidate.getType())) {
                parameterAndArgumentHolder.accept(argCandidate);
                log.debug("Parameter [{}] has bound by name.", (Object)parameterAndArgumentHolder.getParameterName());
                return new ParameterBindingResult(parameterAndArgumentHolder, false);
            }
            if (argCandidate.getObject() != null && parameterAndArgumentHolder.canAccept(argCandidate.getObject().getClass())) {
                parameterAndArgumentHolder.accept(argCandidate);
                log.debug("Parameter [{}] has bound by name.", (Object)parameterAndArgumentHolder.getParameterName());
                return new ParameterBindingResult(parameterAndArgumentHolder, false);
            }
            if (argCandidate.getObject() != null && parameterAndArgumentHolder.canAccept(argCandidate.getObject())) {
                parameterAndArgumentHolder.accept(argCandidate);
                log.debug("Parameter [{}] has bound by name.", (Object)parameterAndArgumentHolder.getParameterName());
                return new ParameterBindingResult(parameterAndArgumentHolder, false);
            }
            log.debug("Parameter [{}] is skipped. (type mismatch). Parameter type is [{}] but the object type is [{}]", new Object[]{parameterAndArgumentHolder.getParameterName(), parameterAndArgumentHolder.getParameterType(), argCandidate.getType()});
            return new ParameterBindingResult(null, true);
        }
        log.debug("No parameter name [{}] in the context.", (Object)parameterAndArgumentHolder.getParameterName());
        return new ParameterBindingResult(null, true);
    }
}

