/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.MethodArgumentBindingStrategy;
import io.github.thecodinglog.methodinvoker.ParameterAndArgumentHolder;
import io.github.thecodinglog.methodinvoker.ParameterBindingResult;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import io.github.thecodinglog.methodinvoker.annotations.ParameterQualifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterQualifierMethodArgumentBindingStrategy
implements MethodArgumentBindingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ParameterQualifierMethodArgumentBindingStrategy.class);

    @Override
    public ParameterBindingResult tryBind(ParameterAndArgumentHolder parameterAndArgumentHolder, Context context) {
        ParameterQualifier annotation = parameterAndArgumentHolder.getParameterAnnotation(ParameterQualifier.class);
        if (annotation != null) {
            String contextKey = annotation.value();
            if (context.hasKey(contextKey)) {
                TypeDescribableObject argCandidate = context.getValueByKey(contextKey);
                if (!parameterAndArgumentHolder.canAccept(argCandidate.getType())) {
                    throw new ClassCastException(String.format("Annotated parameter [%s] is not a instance of [%s]", contextKey, parameterAndArgumentHolder.getParameterType()));
                }
                parameterAndArgumentHolder.accept(argCandidate);
                log.debug("Annotation binding of {}", (Object)contextKey);
                return new ParameterBindingResult(parameterAndArgumentHolder, false);
            }
            return new ParameterBindingResult(null, false);
        }
        return new ParameterBindingResult(null, true);
    }
}

