/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.MethodArgumentBindingStrategy;
import io.github.thecodinglog.methodinvoker.ParameterAndArgumentHolder;
import io.github.thecodinglog.methodinvoker.ParameterBindingResult;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import io.github.thecodinglog.methodinvoker.exceptions.NoUniqueElementException;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterTypeMethodArgumentBindingStrategy
implements MethodArgumentBindingStrategy {
    private static final Logger log = LoggerFactory.getLogger(ParameterTypeMethodArgumentBindingStrategy.class);

    @Override
    public ParameterBindingResult tryBind(ParameterAndArgumentHolder parameterAndArgumentHolder, Context context) {
        if (context.hasType(parameterAndArgumentHolder.getParameterType())) {
            TypeDescribableObject argCandidate;
            try {
                argCandidate = context.getOneValueByType(parameterAndArgumentHolder.getParameterType());
            }
            catch (NoUniqueElementException | NoSuchElementException e) {
                log.debug("[{}] is skipped. No unique parameter set.", (Object)parameterAndArgumentHolder.getParameterType());
                return new ParameterBindingResult(null, false);
            }
            parameterAndArgumentHolder.accept(argCandidate);
            log.debug("Parameter [{}] has bound by type [{}].", (Object)parameterAndArgumentHolder.getParameterName(), (Object)parameterAndArgumentHolder.getParameterType());
            return new ParameterBindingResult(parameterAndArgumentHolder, true);
        }
        log.debug("No parameter type [{}] in the context.", (Object)parameterAndArgumentHolder.getParameterType());
        return new ParameterBindingResult(null, true);
    }
}

