/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.MethodOrConstructor;
import io.github.thecodinglog.methodinvoker.ParameterAndArgumentHolder;
import io.github.thecodinglog.methodinvoker.Prioritizable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class PrioritizableMethodOrConstructorHolder
implements Prioritizable {
    private final MethodOrConstructor methodOrConstructor;
    private final List<? extends ParameterAndArgumentHolder> parameterAndArgumentHolders;
    private final int priority;

    public PrioritizableMethodOrConstructorHolder(MethodOrConstructor methodOrConstructor, List<? extends ParameterAndArgumentHolder> holders) {
        if (methodOrConstructor == null) {
            throw new IllegalArgumentException("The methodOrConstructor can not be null.");
        }
        this.methodOrConstructor = methodOrConstructor;
        this.parameterAndArgumentHolders = holders == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(holders);
        int highestPriority = 0;
        for (Prioritizable prioritizable : this.parameterAndArgumentHolders) {
            if (highestPriority == Integer.MAX_VALUE) break;
            if (prioritizable.priority() <= highestPriority) continue;
            highestPriority = prioritizable.priority();
        }
        this.priority = highestPriority;
    }

    public Constructor<?> constructor() {
        return this.methodOrConstructor.getConstructor();
    }

    public Method method() {
        return this.methodOrConstructor.getMethod();
    }

    public Object[] args() {
        Object[] args = new Object[this.parameterAndArgumentHolders.size()];
        for (int i = 0; i < this.parameterAndArgumentHolders.size(); ++i) {
            Object actualArgument = this.parameterAndArgumentHolders.get(i).getActualArgument();
            if (actualArgument == null) {
                if (!(this.parameterAndArgumentHolders.get(i).getParameterType() instanceof Class) || !((Class)this.parameterAndArgumentHolders.get(i).getParameterType()).isPrimitive()) continue;
                args[i] = this.defaultValueOfPrimitiveType(this.parameterAndArgumentHolders.get(i).getParameterType());
                continue;
            }
            args[i] = this.parameterAndArgumentHolders.get(i).getActualArgument();
        }
        return args;
    }

    private Object defaultValueOfPrimitiveType(Type parameterType) {
        if (parameterType == Byte.TYPE) {
            return (byte)0;
        }
        if (parameterType == Short.TYPE) {
            return (short)0;
        }
        if (parameterType == Integer.TYPE) {
            return 0;
        }
        if (parameterType == Long.TYPE) {
            return 0L;
        }
        if (parameterType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (parameterType == Double.TYPE) {
            return 0.0;
        }
        if (parameterType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (parameterType == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    @Override
    public int priority() {
        return this.priority;
    }
}

