/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.MethodOrConstructorParameter;
import io.github.thecodinglog.methodinvoker.ParameterAndArgumentHolder;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import io.github.thecodinglog.methodinvoker.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

final class PrioritizableParameterAndArgumentHolder
implements ParameterAndArgumentHolder {
    public static final int PRIORITY_STEP = 255;
    private final MethodOrConstructorParameter methodOrConstructorParameter;
    private Object actualArgument;
    private boolean isResolved;
    private int priority;
    private ResolvableType resolvableType;

    public PrioritizableParameterAndArgumentHolder(MethodOrConstructorParameter methodParameter) {
        this.methodOrConstructorParameter = methodParameter;
    }

    @Override
    public String getParameterName() {
        return this.methodOrConstructorParameter.getParameterName();
    }

    @Override
    public Object getActualArgument() {
        return this.actualArgument;
    }

    @Override
    public void accept(TypeDescribableObject actualArgument) {
        if (this.isResolved) {
            throw new IllegalStateException("Actual argument already set");
        }
        if (this.canAccept(actualArgument.getType())) {
            this.actualArgument = this.methodOrConstructorParameter.isPrimitive() && actualArgument.getObject() == null ? this.defaultPrimitiveValue(this.methodOrConstructorParameter.getParameterType()) : actualArgument.getObject();
            this.isResolved = true;
            this.priority = this.evaluatePriority(this.methodOrConstructorParameter.getGenericParameterType(), actualArgument.getType());
        } else if (actualArgument.getObject() != null && this.canAccept(actualArgument.getObject().getClass())) {
            this.actualArgument = actualArgument.getObject();
            this.isResolved = true;
            this.priority = this.evaluatePriority(this.methodOrConstructorParameter.getGenericParameterType(), actualArgument.getType());
        } else if (actualArgument.getObject() != null && this.canAccept(actualArgument.getObject())) {
            this.actualArgument = actualArgument.getObject();
            this.isResolved = true;
            this.priority = this.evaluatePriority(this.methodOrConstructorParameter.getGenericParameterType(), actualArgument.getType());
        } else {
            throw new IllegalArgumentException(String.format("actualArgument is not type of the parameter type [%s]", this.methodOrConstructorParameter.getGenericParameterType()));
        }
    }

    private Object defaultPrimitiveValue(Class<?> parameterType) {
        if (parameterType == Integer.TYPE) {
            return 0;
        }
        if (parameterType == Short.TYPE) {
            return 0;
        }
        if (parameterType == Long.TYPE) {
            return 0L;
        }
        if (parameterType == Byte.TYPE) {
            return 0;
        }
        if (parameterType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (parameterType == Double.TYPE) {
            return 0.0;
        }
        if (parameterType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (parameterType == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    private int evaluatePriority(Type paramType, Type argType) {
        int priority = 0;
        if (paramType == argType) {
            return priority;
        }
        if (ClassUtils.isPrimitiveOrWrapper(this.methodOrConstructorParameter.getParameterType())) {
            return priority;
        }
        ResolvableType type = ResolvableType.forType((Type)argType);
        while (type.resolve() != null && type.resolve() != this.resolvableType.resolve()) {
            priority += 255;
            type = type.getSuperType();
        }
        return priority;
    }

    @Override
    public <T extends Annotation> T getParameterAnnotation(Class<T> tClass) {
        return this.methodOrConstructorParameter.getParameterAnnotation(tClass);
    }

    @Override
    public boolean canAccept(Type type) {
        if (this.resolvableType == null) {
            this.resolvableType = ResolvableType.forMethodParameter((MethodParameter)this.methodOrConstructorParameter.getMethodParameter());
        }
        return TypeUtils.isAssignable(this.resolvableType, type);
    }

    @Override
    public boolean canAccept(Object object) {
        if (TypeUtils.isAssignable(List.class, this.methodOrConstructorParameter.getMethodParameter().getGenericParameterType())) {
            return this.checkIfList(object);
        }
        if (TypeUtils.isAssignable(Map.class, this.methodOrConstructorParameter.getMethodParameter().getGenericParameterType())) {
            return false;
        }
        return TypeUtils.isAssignable(this.methodOrConstructorParameter.getMethodParameter().getParameterType(), object.getClass());
    }

    private boolean checkIfList(Object object) {
        Type actualTypeArgument = ((ParameterizedType)this.methodOrConstructorParameter.getMethodParameter().getGenericParameterType()).getActualTypeArguments()[0];
        if (!(object instanceof List)) {
            return false;
        }
        List objectList = (List)object;
        if (objectList.size() == 0) {
            return true;
        }
        return TypeUtils.isAssignable(actualTypeArgument, objectList.get(0).getClass());
    }

    @Override
    public Type getParameterType() {
        return this.methodOrConstructorParameter.getGenericParameterType();
    }

    @Override
    public int priority() {
        return this.priority;
    }
}

