/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.CandidateMethodsSelector;
import io.github.thecodinglog.methodinvoker.MethodNotFoundException;
import io.github.thecodinglog.methodinvoker.TooManyDefaultException;
import io.github.thecodinglog.methodinvoker.annotations.DefaultMethod;
import io.github.thecodinglog.methodinvoker.annotations.MethodQualifier;
import io.github.thecodinglog.methodinvoker.exceptions.NoUniqueQualifierException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class PublicCandidateMethodsSelector
implements CandidateMethodsSelector {
    PublicCandidateMethodsSelector() {
    }

    @Override
    public Method[] select(Class<?> clazz, String qualifier) {
        Method[] methods = clazz.getMethods();
        if (methods.length == 0) {
            throw new MethodNotFoundException("No public method exists. : " + clazz.getName());
        }
        Method defaultMethodIfExists = this.getDefaultMethodIfExists(methods);
        if (qualifier == null && defaultMethodIfExists == null) {
            throw new MethodNotFoundException("No default method exists. : " + clazz.getName());
        }
        if (qualifier == null) {
            return new Method[]{defaultMethodIfExists};
        }
        Method qualifiedMethodIfExists = this.getQualifiedMethodIfExists(methods, qualifier);
        if (qualifiedMethodIfExists != null) {
            return new Method[]{qualifiedMethodIfExists};
        }
        Method[] methodsMatchingQualifierAndMethodName = this.getMethodsMatchingQualifierAndMethodName(methods, qualifier);
        if (methodsMatchingQualifierAndMethodName.length == 0) {
            throw new MethodNotFoundException("No public method [" + qualifier + "] of class [" + clazz.getName() + "]");
        }
        return methodsMatchingQualifierAndMethodName;
    }

    private Method[] getMethodsMatchingQualifierAndMethodName(Method[] methods, String qualifier) {
        ArrayList<Method> qualifiedMethods = new ArrayList<Method>(methods.length);
        for (Method method : methods) {
            if (!method.getName().equals(qualifier)) continue;
            qualifiedMethods.add(method);
        }
        return qualifiedMethods.toArray(new Method[0]);
    }

    private Method getQualifiedMethodIfExists(Method[] methods, String qualifier) {
        HashMap<String, Method> qualifiedMethods = new HashMap<String, Method>(methods.length);
        for (Method method : methods) {
            String annotationAndGetValue = (String)this.findAnnotationAndGetValue(method, MethodQualifier.class);
            if (annotationAndGetValue == null) continue;
            if (qualifiedMethods.containsKey(annotationAndGetValue)) {
                throw new NoUniqueQualifierException(annotationAndGetValue + " is not unique qualifier.");
            }
            qualifiedMethods.put(annotationAndGetValue, method);
        }
        return (Method)qualifiedMethods.get(qualifier);
    }

    private Object findAnnotationAndGetValue(Method method, Class<? extends Annotation> annotationType) {
        Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
        HashSet<Class<? extends Annotation>> failedSet = new HashSet<Class<? extends Annotation>>();
        for (Annotation declaredAnnotation : declaredAnnotations) {
            Object value;
            Method valueMethod;
            try {
                valueMethod = declaredAnnotation.annotationType().getMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                failedSet.add(declaredAnnotation.annotationType());
                continue;
            }
            try {
                value = valueMethod.invoke((Object)declaredAnnotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                failedSet.add(declaredAnnotation.annotationType());
                continue;
            }
            if (!(value instanceof String)) {
                failedSet.add(declaredAnnotation.annotationType());
                continue;
            }
            if (declaredAnnotation.annotationType() == annotationType) {
                return value;
            }
            boolean b = this.hasAnnotation(declaredAnnotation, annotationType, failedSet);
            if (!b) continue;
            return value;
        }
        return null;
    }

    private boolean hasAnnotation(Annotation annotation, Class<?> annotationType, Set<Class<? extends Annotation>> failedSet) {
        Annotation[] declaredAnnotations;
        for (Annotation declaredAnnotation : declaredAnnotations = annotation.annotationType().getDeclaredAnnotations()) {
            if (failedSet.contains(declaredAnnotation.annotationType()) || failedSet.contains(declaredAnnotation.annotationType())) continue;
            if (declaredAnnotation.annotationType() == annotationType) {
                return true;
            }
            failedSet.add(declaredAnnotation.annotationType());
            boolean b = this.hasAnnotation(declaredAnnotation, annotationType, failedSet);
            if (!b) continue;
            return true;
        }
        return false;
    }

    private Method getDefaultMethodIfExists(Method[] methods) {
        ArrayList<Method> defaultMethods = new ArrayList<Method>(methods.length);
        for (Method method : methods) {
            if (method.getAnnotation(DefaultMethod.class) == null) continue;
            defaultMethods.add(method);
        }
        if (defaultMethods.size() > 1) {
            throw new TooManyDefaultException("More then one DefaultMethod exists.");
        }
        if (defaultMethods.size() == 1) {
            return (Method)defaultMethods.get(0);
        }
        return null;
    }
}

