/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.CandidateConstructorsSelector;
import io.github.thecodinglog.methodinvoker.ConstructorNotFoundException;
import io.github.thecodinglog.methodinvoker.TooManyDefaultException;
import io.github.thecodinglog.methodinvoker.annotations.ConstructorQualifier;
import io.github.thecodinglog.methodinvoker.annotations.DefaultConstructor;
import io.github.thecodinglog.methodinvoker.exceptions.NoUniqueQualifierException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;

final class PublicOnlyCandidateConstructorsSelector
implements CandidateConstructorsSelector {
    PublicOnlyCandidateConstructorsSelector() {
    }

    @Override
    public Constructor<?>[] select(Class<?> clazz, String qualifier) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
            if (declaredConstructors.length == 1 && declaredConstructors[0].getModifiers() == 0) {
                constructors = declaredConstructors;
            } else {
                throw new ConstructorNotFoundException("No public constructor exists. : " + clazz.getName());
            }
        }
        Constructor<?> defaultConstructor = this.getDefaultConstructorIfExists(constructors);
        if (qualifier == null) {
            Constructor<?>[] constructorArray;
            if (defaultConstructor == null) {
                constructorArray = constructors;
            } else {
                Constructor[] constructorArray2 = new Constructor[1];
                constructorArray = constructorArray2;
                constructorArray2[0] = defaultConstructor;
            }
            return constructorArray;
        }
        Constructor<?> qualifiedConstructor = this.getQualifiedConstructorIfExists(constructors, qualifier);
        if (qualifiedConstructor == null) {
            throw new ConstructorNotFoundException("No public constructor [" + qualifier + "] of class [" + clazz.getName() + "]");
        }
        return new Constructor[]{qualifiedConstructor};
    }

    private Constructor<?> getQualifiedConstructorIfExists(Constructor<?>[] constructors, String qualifier) {
        HashMap qualifiedConstructors = new HashMap(constructors.length);
        for (Constructor<?> constructor : constructors) {
            ConstructorQualifier annotation = constructor.getAnnotation(ConstructorQualifier.class);
            if (annotation == null) continue;
            if (qualifiedConstructors.containsKey(annotation.value())) {
                throw new NoUniqueQualifierException("[" + annotation.value() + "] is not unique qualifier.");
            }
            qualifiedConstructors.put(annotation.value(), constructor);
        }
        if (qualifiedConstructors.size() == 0) {
            throw new ConstructorNotFoundException("No constructor qualifier exists.");
        }
        return (Constructor)qualifiedConstructors.get(qualifier);
    }

    private Constructor<?> getDefaultConstructorIfExists(Constructor<?>[] constructors) {
        ArrayList defaultConstructors = new ArrayList(constructors.length);
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(DefaultConstructor.class) == null) continue;
            defaultConstructors.add(constructor);
        }
        if (defaultConstructors.size() > 1) {
            throw new TooManyDefaultException("Too many default constructors.");
        }
        if (defaultConstructors.size() == 1) {
            return (Constructor)defaultConstructors.get(0);
        }
        return null;
    }
}

