/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import io.github.thecodinglog.methodinvoker.TypeUtils;
import io.github.thecodinglog.methodinvoker.exceptions.NoUniqueElementException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SingleLevelContext
implements Context {
    private final Set<String> optionalParameters = new HashSet<String>();
    private final Map<String, TypeDescribableObject> store = new HashMap<String, TypeDescribableObject>();

    @Override
    public TypeDescribableObject getValueByKey(String key) {
        return this.store.get(key);
    }

    @Override
    public TypeDescribableObject getOneValueByType(Type type) {
        List<String> keys = this.extractKeysByType(type);
        if (keys.size() > 1) {
            throw new NoUniqueElementException("No unique.");
        }
        if (keys.size() == 0) {
            throw new NoSuchElementException("No element.");
        }
        return this.store.get(keys.get(0));
    }

    private List<String> extractKeysByType(Type type) {
        ArrayList<String> keys = new ArrayList<String>(this.store.entrySet().size());
        for (Map.Entry<String, TypeDescribableObject> entry : this.store.entrySet()) {
            if (!TypeUtils.isAssignable(type, entry.getValue().getType())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public boolean hasKey(String key) {
        return this.store.containsKey(key);
    }

    @Override
    public boolean hasType(Type type) {
        return this.extractKeysByType(type).size() > 0;
    }

    @Override
    public void add(String key, TypeDescribableObject typeDescribableObject) {
        this.store.put(key, typeDescribableObject);
    }

    public void addOptionalParameter(String key) {
        this.optionalParameters.add(key);
    }

    @Override
    public Set<String> optionalParameters() {
        return Collections.unmodifiableSet(this.optionalParameters);
    }
}

