/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.CandidateConstructorsSelector;
import io.github.thecodinglog.methodinvoker.ConstructorNotFoundException;
import io.github.thecodinglog.methodinvoker.ConstructorResolver;
import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.MethodArgumentBinder;
import io.github.thecodinglog.methodinvoker.MethodBindingException;
import io.github.thecodinglog.methodinvoker.MethodOrConstructor;
import io.github.thecodinglog.methodinvoker.Prioritizable;
import io.github.thecodinglog.methodinvoker.PrioritizableMethodOrConstructorHolder;
import io.github.thecodinglog.methodinvoker.PriorityPicker;
import io.github.thecodinglog.methodinvoker.PriorityPickingException;
import io.github.thecodinglog.methodinvoker.TooManyDefaultException;
import io.github.thecodinglog.methodinvoker.exceptions.NoUniqueQualifierException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;

final class StrictConstructorResolver
implements ConstructorResolver {
    private final CandidateConstructorsSelector candidateResolver;
    private final MethodArgumentBinder methodArgumentBinder;
    private final PriorityPicker priorityPicker;

    public StrictConstructorResolver(CandidateConstructorsSelector candidateResolver, MethodArgumentBinder methodArgumentBinder, PriorityPicker priorityPicker) {
        this.candidateResolver = candidateResolver;
        this.methodArgumentBinder = methodArgumentBinder;
        this.priorityPicker = priorityPicker;
    }

    @Override
    public PrioritizableMethodOrConstructorHolder resolve(Class<?> aClass, Context context) {
        Prioritizable pick;
        Constructor<?>[] constructors;
        try {
            constructors = this.candidateResolver.select(aClass, null);
        }
        catch (TooManyDefaultException | NoUniqueQualifierException e) {
            throw new ConstructorNotFoundException(e.getMessage(), e);
        }
        catch (ConstructorNotFoundException e) {
            throw e;
        }
        Arrays.sort(constructors, (e1, e2) -> Integer.compare(e2.getParameterCount(), e1.getParameterCount()));
        int beforeConstructorParameterLength = Integer.MAX_VALUE;
        ArrayList<PrioritizableMethodOrConstructorHolder> candidatesConstructors = new ArrayList<PrioritizableMethodOrConstructorHolder>(constructors.length);
        for (Constructor<?> constructor : constructors) {
            PrioritizableMethodOrConstructorHolder holder;
            if (beforeConstructorParameterLength > constructor.getParameters().length && candidatesConstructors.size() > 0) break;
            try {
                holder = this.methodArgumentBinder.bind(new MethodOrConstructor(constructor), context);
            }
            catch (MethodBindingException e) {
                throw new ConstructorNotFoundException(e.getMessage(), e);
            }
            if (holder != null) {
                candidatesConstructors.add(holder);
            }
            beforeConstructorParameterLength = constructor.getParameters().length;
        }
        if (candidatesConstructors.size() == 0) {
            throw new ConstructorNotFoundException("No candidate constructors : " + aClass.getName());
        }
        try {
            pick = this.priorityPicker.pick(candidatesConstructors);
        }
        catch (PriorityPickingException e) {
            throw new ConstructorNotFoundException(e.getMessage(), e);
        }
        return (PrioritizableMethodOrConstructorHolder)pick;
    }
}

