/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.DefaultObjectFactory;
import io.github.thecodinglog.methodinvoker.HighestPriorityPicker;
import io.github.thecodinglog.methodinvoker.MethodArgumentBinder;
import io.github.thecodinglog.methodinvoker.MethodInvoker;
import io.github.thecodinglog.methodinvoker.MethodNotFoundException;
import io.github.thecodinglog.methodinvoker.MethodResolver;
import io.github.thecodinglog.methodinvoker.ObjectFactory;
import io.github.thecodinglog.methodinvoker.PrioritizableMethodOrConstructorHolder;
import io.github.thecodinglog.methodinvoker.PriorityPicker;
import io.github.thecodinglog.methodinvoker.PublicCandidateMethodsSelector;
import io.github.thecodinglog.methodinvoker.PublicOnlyCandidateConstructorsSelector;
import io.github.thecodinglog.methodinvoker.StrictConstructorResolver;
import io.github.thecodinglog.methodinvoker.StrictMethodResolver;
import io.github.thecodinglog.methodinvoker.TypeDescribableObject;
import io.github.thecodinglog.methodinvoker.TypeMatchableMethodArgumentBinder;
import io.github.thecodinglog.methodinvoker.exceptions.MethodInvokeException;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrictMethodInvoker
implements MethodInvoker {
    private static final Logger log = LoggerFactory.getLogger(StrictMethodInvoker.class);
    private final MethodArgumentBinder binder = new TypeMatchableMethodArgumentBinder();
    private final PriorityPicker picker = new HighestPriorityPicker();
    private final MethodResolver methodResolver = new StrictMethodResolver(new PublicCandidateMethodsSelector(), this.binder, this.picker);
    private final ObjectFactory objectFactory = new DefaultObjectFactory(new StrictConstructorResolver(new PublicOnlyCandidateConstructorsSelector(), this.binder, this.picker));

    public ObjectFactory objectFactory() {
        return this.objectFactory;
    }

    @Override
    public TypeDescribableObject invoke(Object object, String methodName, Context context) {
        Object invoke;
        PrioritizableMethodOrConstructorHolder resolve;
        try {
            resolve = methodName != null ? this.methodResolver.resolve(object.getClass(), methodName, context) : this.methodResolver.resolve(object.getClass(), context);
        }
        catch (MethodNotFoundException e) {
            throw new MethodInvokeException(e.getMessage(), e);
        }
        log.debug("Method [{}] selected.", (Object)resolve.method().toGenericString());
        try {
            resolve.method().setAccessible(true);
            invoke = resolve.method().invoke(object, resolve.args());
        }
        catch (IllegalAccessException e) {
            throw new MethodInvokeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new MethodInvokeException(e.getMessage(), e);
        }
        finally {
            resolve.method().setAccessible(false);
        }
        return new TypeDescribableObject(invoke, resolve.method().getGenericReturnType());
    }

    @Override
    public TypeDescribableObject invoke(Class<?> clazz, String methodName, Context context) {
        Object object = this.objectFactory.createObject(clazz, context);
        return this.invoke(object, methodName, context);
    }

    @Override
    public TypeDescribableObject invoke(String fullQualifiedClassName, String methodName, Context context) {
        Object object = this.objectFactory.createObject(fullQualifiedClassName, context);
        return this.invoke(object, methodName, context);
    }
}

