/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.CandidateMethodsSelector;
import io.github.thecodinglog.methodinvoker.Context;
import io.github.thecodinglog.methodinvoker.MethodArgumentBinder;
import io.github.thecodinglog.methodinvoker.MethodNotFoundException;
import io.github.thecodinglog.methodinvoker.MethodOrConstructor;
import io.github.thecodinglog.methodinvoker.MethodResolver;
import io.github.thecodinglog.methodinvoker.Prioritizable;
import io.github.thecodinglog.methodinvoker.PrioritizableMethodOrConstructorHolder;
import io.github.thecodinglog.methodinvoker.PriorityPicker;
import io.github.thecodinglog.methodinvoker.PriorityPickingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StrictMethodResolver
implements MethodResolver {
    private static final Logger log = LoggerFactory.getLogger(StrictMethodResolver.class);
    private final CandidateMethodsSelector candidateMethodsSelector;
    private final MethodArgumentBinder methodArgumentBinder;
    private final PriorityPicker priorityPicker;

    public StrictMethodResolver(CandidateMethodsSelector candidateMethodsSelector, MethodArgumentBinder methodArgumentBinder, PriorityPicker priorityPicker) {
        this.candidateMethodsSelector = candidateMethodsSelector;
        this.methodArgumentBinder = methodArgumentBinder;
        this.priorityPicker = priorityPicker;
    }

    @Override
    public PrioritizableMethodOrConstructorHolder resolve(Class<?> aClass, String methodName, Context context) {
        Prioritizable pick;
        Method[] methods = this.candidateMethodsSelector.select(aClass, methodName);
        Arrays.sort(methods, (e1, e2) -> Integer.compare(e2.getParameterCount(), e1.getParameterCount()));
        int beforeConstructorParameterLength = Integer.MAX_VALUE;
        ArrayList<PrioritizableMethodOrConstructorHolder> candidatesMethods = new ArrayList<PrioritizableMethodOrConstructorHolder>(methods.length);
        for (Method method : methods) {
            if (beforeConstructorParameterLength > method.getParameters().length && candidatesMethods.size() > 0) break;
            log.debug("Try bind [{}]", (Object)method.toGenericString());
            PrioritizableMethodOrConstructorHolder holder = this.methodArgumentBinder.bind(new MethodOrConstructor(method), context);
            if (holder != null) {
                candidatesMethods.add(holder);
            }
            beforeConstructorParameterLength = method.getParameters().length;
        }
        if (candidatesMethods.size() == 0) {
            throw new MethodNotFoundException(String.format("No suitable method. : Class[%s], Method[%s]", aClass.getName(), methodName));
        }
        try {
            pick = this.priorityPicker.pick(candidatesMethods);
        }
        catch (PriorityPickingException e) {
            throw new MethodNotFoundException(String.format("PriorityPicker exception : %s", aClass.getName()), e);
        }
        return (PrioritizableMethodOrConstructorHolder)pick;
    }

    @Override
    public PrioritizableMethodOrConstructorHolder resolve(Class<?> aClass, Context context) {
        return this.resolve(aClass, null, context);
    }
}

