/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecodinglog.methodinvoker;

import io.github.thecodinglog.methodinvoker.TypeReference;
import io.github.thecodinglog.methodinvoker.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class TypeDescribableObject {
    private final Object object;
    private final Type type;

    public TypeDescribableObject(Object object, TypeReference<?> typeReference) {
        this.object = object;
        this.type = typeReference.getType();
        this.typeCheck(object);
    }

    public TypeDescribableObject(Object object, Type type) {
        this.object = object;
        this.type = type;
        this.typeCheck(object);
    }

    public TypeDescribableObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The type cannot be determined because object is null.Use a constructor that specifies the type explicitly.");
        }
        this.object = object;
        if (object.getClass().getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Generic type");
        }
        this.type = object.getClass();
    }

    private void typeCheck(Object object) {
        if (object == null) {
            return;
        }
        if (this.type instanceof ParameterizedType) {
            boolean instance;
            Type rawType = ((ParameterizedType)this.type).getRawType();
            if (rawType instanceof Class && !(instance = ((Class)rawType).isInstance(object))) {
                throw new IllegalArgumentException("Incompatible parameterized type.");
            }
        } else if (this.type instanceof Class) {
            if (!((Class)this.type).isInstance(object) && !TypeUtils.isInstance(this.type, object)) {
                throw new IllegalArgumentException("Incompatible type.");
            }
        } else if (this.type instanceof TypeVariable) {
            TypeUtils.isInstance(this.type, object);
        } else {
            throw new IllegalArgumentException("Incompatible type.");
        }
    }

    public Object getObject() {
        return this.object;
    }

    public <T> T getObject(Class<T> t) {
        return t.cast(this.object);
    }

    public Type getType() {
        return this.type;
    }
}

