/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.instrument.config.InvalidConfigurationException;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.registry.otlp.AggregationTemporality;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface OtlpConfig
extends PushRegistryConfig {
    public static final OtlpConfig DEFAULT = key -> null;

    default public String prefix() {
        return "otlp";
    }

    default public String url() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"url").orElseGet(() -> {
            Map<String, String> env = System.getenv();
            String endpoint = env.get("OTEL_EXPORTER_OTLP_METRICS_ENDPOINT");
            if (endpoint == null) {
                endpoint = env.get("OTEL_EXPORTER_OTLP_ENDPOINT");
            }
            if (endpoint == null) {
                endpoint = "http://localhost:4318/v1/metrics";
            } else if (!endpoint.endsWith("/v1/metrics")) {
                endpoint = endpoint + "/v1/metrics";
            }
            return endpoint;
        });
    }

    default public Duration step() {
        Validated step = PropertyValidator.getDuration((MeterRegistryConfig)this, (String)"step");
        return (Duration)step.orElseGet(() -> {
            String exportInterval = System.getenv().get("OTEL_METRIC_EXPORT_INTERVAL");
            if (exportInterval != null) {
                return Duration.ofMillis(Long.parseLong(exportInterval));
            }
            return super.step();
        });
    }

    default public Map<String, String> resourceAttributes() {
        Map<String, String> env = System.getenv();
        String resourceAttributesConfig = (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"resourceAttributes").orElse((Object)env.get("OTEL_RESOURCE_ATTRIBUTES"));
        String[] splitResourceAttributesString = resourceAttributesConfig == null ? new String[]{} : resourceAttributesConfig.trim().split(",");
        Map<String, String> resourceAttributes = Arrays.stream(splitResourceAttributesString).map(String::trim).filter(keyValue -> keyValue.length() > 2 && keyValue.indexOf(61) > 0).collect(Collectors.toMap(keyvalue -> keyvalue.substring(0, keyvalue.indexOf(61)).trim(), keyValue -> keyValue.substring(keyValue.indexOf(61) + 1).trim()));
        if (env.containsKey("OTEL_SERVICE_NAME") && !resourceAttributes.containsKey("service.name")) {
            resourceAttributes.put("service.name", env.get("OTEL_SERVICE_NAME"));
        }
        return resourceAttributes;
    }

    default public AggregationTemporality aggregationTemporality() {
        return (AggregationTemporality)((Object)PropertyValidator.getEnum((MeterRegistryConfig)this, AggregationTemporality.class, (String)"aggregationTemporality").orElseGet(() -> {
            String preference = System.getenv().get("OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE");
            if (preference != null) {
                return AggregationTemporality.valueOf(preference.toUpperCase());
            }
            return AggregationTemporality.CUMULATIVE;
        }));
    }

    default public Map<String, String> headers() {
        String headersString = (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"headers").orElse(null);
        if (headersString == null) {
            Map<String, String> env = System.getenv();
            headersString = env.getOrDefault("OTEL_EXPORTER_OTLP_HEADERS", "").trim();
            String metricsHeaders = env.getOrDefault("OTEL_EXPORTER_OTLP_METRICS_HEADERS", "").trim();
            headersString = Objects.equals(headersString, "") ? metricsHeaders : headersString + "," + metricsHeaders;
            try {
                headersString = URLDecoder.decode(headersString, "UTF-8");
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Cannot URL decode header value: " + headersString, (Throwable)e);
            }
        }
        String[] keyValues = Objects.equals(headersString, "") ? new String[]{} : headersString.split(",");
        return Arrays.stream(keyValues).map(String::trim).filter(keyValue -> keyValue.length() > 2 && keyValue.indexOf(61) > 0).collect(Collectors.toMap(keyValue -> keyValue.substring(0, keyValue.indexOf(61)).trim(), keyValue -> keyValue.substring(keyValue.indexOf(61) + 1).trim(), (l, r) -> r));
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> PushRegistryConfig.validate((PushRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"url", OtlpConfig::url), MeterRegistryConfigValidator.check((String)"resourceAttributes", OtlpConfig::resourceAttributes), MeterRegistryConfigValidator.check((String)"baseTimeUnit", OtlpConfig::baseTimeUnit), MeterRegistryConfigValidator.check((String)"aggregationTemporality", OtlpConfig::aggregationTemporality)});
    }

    default public TimeUnit baseTimeUnit() {
        return (TimeUnit)((Object)PropertyValidator.getTimeUnit((MeterRegistryConfig)this, (String)"baseTimeUnit").orElse((Object)TimeUnit.MILLISECONDS));
    }
}

