/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import java.util.Locale;
import javax.annotation.Nullable;

final class ForwardedHeaderParser {
    @Nullable
    static String extractProtoFromForwardedHeader(String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("proto=");
        if (start < 0) {
            return null;
        }
        if ((start += 6) >= forwarded.length() - 1) {
            return null;
        }
        return ForwardedHeaderParser.extractProto(forwarded, start);
    }

    @Nullable
    static String extractProtoFromForwardedProtoHeader(String forwardedProto) {
        return ForwardedHeaderParser.extractProto(forwardedProto, 0);
    }

    @Nullable
    static String extractClientIpFromForwardedHeader(String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        return ForwardedHeaderParser.extractIpAddress(forwarded, start);
    }

    @Nullable
    static String extractClientIpFromForwardedForHeader(String forwardedFor) {
        return ForwardedHeaderParser.extractIpAddress(forwardedFor, 0);
    }

    @Nullable
    private static String extractProto(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return ForwardedHeaderParser.extractProto(forwarded, start + 1);
        }
        for (int i = start; i < forwarded.length(); ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';' && c != '\"') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    @Nullable
    private static String extractIpAddress(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return ForwardedHeaderParser.extractIpAddress(forwarded, start + 1);
        }
        if (forwarded.charAt(start) == '[') {
            int end = forwarded.indexOf(93, start + 1);
            if (end == -1) {
                return null;
            }
            return forwarded.substring(start + 1, end);
        }
        boolean inIpv4 = false;
        for (int i = start; i < forwarded.length(); ++i) {
            char c = forwarded.charAt(i);
            if (c == '.') {
                inIpv4 = true;
                continue;
            }
            if (c != ',' && c != ';' && c != '\"' && (!inIpv4 || c != ':')) continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private ForwardedHeaderParser() {
    }
}

